module net.BurtonRadons.dig.platform.windowsTheme;

/+
#ifdef DOXYGEN_JUST_HURTS_ITSELF_HERE
+/

private import net.BurtonRadons.dig.platform.windows;
private import net.BurtonRadons.dig.platform.base;

//private import std.c.windows.windows;


class WindowsTheme
{
static:
    bit available; /**< Set if theming is available. */

    extern (Windows)
    {
        _HRESULT (*CloseThemeData) (HTHEME hTheme);
        _HRESULT (*DrawThemeBackground) (HTHEME hTheme, _HDC hdc, int iPartId, int iStateId, _RECT *pRect, _RECT *pClipRect);
        _HRESULT (*DrawThemeEdge) (HTHEME hTheme, _HDC hdc, int iPartId, int iStateId, _RECT *pDestRect, _UINT uEdge, _UINT uFlags, _RECT *pContentRect);
        _HRESULT (*DrawThemeIcon) (HTHEME hTheme, _HDC hdc, int iPartId, int iStateId, _RECT *pRect, HIMAGELIST himl, int iImageIndex);
        _HRESULT (*DrawThemeText) (HTHEME hTheme, _HDC hdc, int iPartId, int iStateId, _LPCWSTR pszText, int iCharCount, _DWORD dwTextFlags, _DWORD dwTextFlags2, _RECT *pRect);
        _HRESULT (*GetCurrentThemeName) (_LPWSTR pszThemeFileName, int dwMaxNameChars, _LPWSTR pszColorBuff, int cchMaxColorChars, _LPWSTR pszSizeBuff, int cchMaxSizeChars);
        _HRESULT (*GetThemeBool) (HTHEME hTheme, int iPartId, int iStateId, int iPropId, _BOOL *pfVal);
        _HRESULT (*GetThemeColor) (HTHEME hTheme, int iPartId, int iStateId, int iPropId, _COLORREF *pColor);
        _HRESULT (*GetThemeEnumValue) (HTHEME hTheme, int iPartId, int iStateId, int iPropId, int *piVal);
        _HRESULT (*GetThemeFilename) (HTHEME hTheme, int iPartId, int iStateId, int iPropId, _LPWSTR pszThemeFilename, int cchMaxBuffChars);
        _HRESULT (*GetThemeFont) (HTHEME hTheme, _HDC hdc, int iPartId, int iStateId, int iPropId, LOGFONT *pFont);
        _HRESULT (*GetThemeInt) (HTHEME hTheme, int iPartId, int iStateId, int iPropId, int *piVal);
        _HRESULT (*GetThemeMargins) (HTHEME hTheme, _HDC hdc, int iPartId, int iStateId, int iPropId, _RECT *prc, MARGINS *pMargins);
        _HRESULT (*GetThemePartSize) (HTHEME hTheme, _HDC hdc, int iPartId, int iStateId, _RECT *prc, THEMESIZE eSize, SIZE *psz);
        _HRESULT (*GetThemePosition) (HTHEME hTheme, int iPartId, int iStateId, int iPropId, _POINT *pPoint);
        _HRESULT (*GetThemeTextExtent) (HTHEME hTheme, _HDC hdc, int iPartId, int iStateId, _LPCWSTR pszText, int iCharCount, _DWORD dwTextFlags, _RECT *pBoundingRect, _RECT *pExtentRect);
        _BOOL (*IsThemePartDefined) (HTHEME hTheme, int iPartId, int iStateId);
        HTHEME (*OpenThemeData) (_HWND hwnd, _LPCWSTR pszClassList);
        void (*SetThemeAppProperties) (_DWORD dwFlags);
    }

    static this ()
    {
        uxtheme = std.c.windows.windows.LoadLibraryA ("uxtheme.dll");
        if (!uxtheme)
            return;
        available = true;
        uxtheme_load ((void **) &OpenThemeData, "OpenThemeData");
        uxtheme_load ((void **) &GetCurrentThemeName, "GetCurrentThemeName");
        uxtheme_load ((void **) &SetThemeAppProperties, "SetThemeAppProperties");
        uxtheme_load ((void **) &CloseThemeData, "CloseThemeData");
        uxtheme_load ((void **) &DrawThemeBackground, "DrawThemeBackground");
        uxtheme_load ((void **) &DrawThemeText, "DrawThemeText");
        uxtheme_load ((void **) &GetThemeColor, "GetThemeColor");
        uxtheme_load ((void **) &GetThemeEnumValue, "GetThemeEnumValue");
        uxtheme_load ((void **) &GetThemeFilename, "GetThemeFilename");
        uxtheme_load ((void **) &GetThemeInt, "GetThemeInt");
        uxtheme_load ((void **) &GetThemeTextExtent, "GetThemeTextExtent");
        uxtheme_load ((void **) &GetThemeMargins, "GetThemeMargins");
        uxtheme_load ((void **) &GetThemePosition, "GetThemePosition");
        uxtheme_load ((void **) &GetThemeFont, "GetThemeFont");
        uxtheme_load ((void **) &GetThemeBool, "GetThemeBool");
        uxtheme_load ((void **) &DrawThemeIcon, "DrawThemeIcon");
        uxtheme_load ((void **) &IsThemePartDefined, "IsThemePartDefined");
        uxtheme_load ((void **) &DrawThemeEdge, "DrawThemeEdge");
        uxtheme_load ((void **) &GetThemePartSize, "GetThemePartSize");
    }

    void uxtheme_load (void **pointer, char [] name)
    {
        *pointer = std.c.windows.windows.GetProcAddress (uxtheme, std.string.toStringz (name));
    }

    _HMODULE uxtheme;

    const int STAP_ALLOW_NONCLIENT = 0x1;
    const int STAP_ALLOW_CONTROLS = 0x2;
    
    enum THEMESIZE : int
    {
        TS_MIN,             // minimum size
        TS_TRUE,            // size without stretching
        TS_DRAW,            // size that theme mgr will use to draw part
    }

    //   "Button" Parts & States - BUTTON
    const int BP_PUSHBUTTON = 1;
        const int PBS_NORMAL = 1;
        const int PBS_HOT = 2;
        const int PBS_PRESSED = 3;
        const int PBS_DISABLED = 4;
        const int PBS_DEFAULTED = 5;
    const int BP_RADIOBUTTON = 2;
        const int RBS_UNCHECKEDNORMAL = 1;
        const int RBS_UNCHECKEDHOT = 2;
        const int RBS_UNCHECKEDPRESSED = 3;
        const int RBS_UNCHECKEDDISABLED = 4;
        const int RBS_CHECKEDNORMAL = 5;
        const int RBS_CHECKEDHOT = 6;
        const int RBS_CHECKEDPRESSED = 7;
        const int RBS_CHECKEDDISABLED = 8;
    const int BP_CHECKBOX = 3;
        const int CBS_UNCHECKEDNORMAL = 1;
        const int CBS_UNCHECKEDHOT = 2;
        const int CBS_UNCHECKEDPRESSED = 3;
        const int CBS_UNCHECKEDDISABLED = 4;
        const int CBS_CHECKEDNORMAL = 5;
        const int CBS_CHECKEDHOT = 6;
        const int CBS_CHECKEDPRESSED = 7;
        const int CBS_CHECKEDDISABLED = 8;
        const int CBS_MIXEDNORMAL = 9;
        const int CBS_MIXEDHOT = 10;
        const int CBS_MIXEDPRESSED = 11;
        const int CBS_MIXEDDISABLED = 12;
    const int BP_GROUPBOX = 4;
        const int GBS_NORMAL = 1;
        const int GBS_DISABLED = 2;
    const int BP_USERBUTTON = 5;

    // "Taskbar Clock" Parts & States - CLOCK
    const int CLP_TIME = 1;
        const int CLS_NORMAL = 1;

    //   "ComboBox" Parts & States - COMBOBOX
    const int CP_DROPDOWNBUTTON = 1;
        const int CBXS_NORMAL = 1;
        const int CBXS_HOT = 2;
        const int CBXS_PRESSED = 3;
        const int CBXS_DISABLED = 4;

    // "Edit" Parts & States - EDIT
    const int EP_EDITTEXT = 1;
        const int ETS_NORMAL = 1;
        const int ETS_HOT = 2;
        const int ETS_SELECTED = 3;
        const int ETS_DISABLED = 4;
        const int ETS_FOCUSED = 5;
        const int ETS_READONLY = 6;
        const int ETS_ASSIST = 7;
    const int EP_CARET = 2;

    // "ExplorerBar" Parts & States - EXPLORERBAR
    const int EBP_HEADERBACKGROUND = 1;
    const int EBP_HEADERCLOSE = 2;
        const int EBHC_NORMAL = 1;
        const int EBHC_HOT = 2;
        const int EBHC_PRESSED = 3;
    const int EBP_HEADERPIN = 3;
        const int EBHP_NORMAL = 1;
        const int EBHP_HOT = 2;
        const int EBHP_PRESSED = 3;
        const int EBHP_SELECTEDNORMAL = 4;
        const int EBHP_SELECTEDHOT = 5;
        const int EBHP_SELECTEDPRESSED = 6;
    const int EBP_IEBARMENU = 4;
        const int EBM_NORMAL = 1;
        const int EBM_HOT = 2;
        const int EBM_PRESSED = 3;
    const int EBP_NORMALGROUPBACKGROUND = 5;
    const int EBP_NORMALGROUPCOLLAPSE = 6;
        const int EBNGC_NORMAL = 1;
        const int EBNGC_HOT = 2;
        const int EBNGC_PRESSED = 3;
    const int EBP_NORMALGROUPEXPAND = 7;
        const int EBNGE_NORMAL = 1;
        const int EBNGE_HOT = 2;
        const int EBNGE_PRESSED = 3;
    const int EBP_NORMALGROUPHEAD = 8;
    const int EBP_SPECIALGROUPBACKGROUND = 9;
    const int EBP_SPECIALGROUPCOLLAPSE = 10;
        const int EBSGC_NORMAL = 1;
        const int EBSGC_HOT = 2;
        const int EBSGC_PRESSED = 3;
    const int EBP_SPECIALGROUPEXPAND = 11;
        const int EBSGE_NORMAL = 1;
        const int EBSGE_HOT = 2;
        const int EBSGE_PRESSED = 3;
    const int EBP_SPECIALGROUPHEAD = 12;

    // GLOBALS - synthesized
    const int GP_BORDER = 1;
    const int GP_LINEHORZ = 2;
    const int GP_LINEVERT = 3;

    // "Header" Parts & States - HEADER
    const int HP_HEADERITEM = 1;
        const int HIS_NORMAL = 1;
        const int HIS_HOT = 2;
        const int HIS_PRESSED = 3;
    const int HP_HEADERITEMLEFT = 2;
        const int HILS_NORMAL = 1;
        const int HILS_HOT = 2;
        const int HILS_PRESSED = 3;
    const int HP_HEADERITEMRIGHT = 3;
        const int HIRS_NORMAL = 1;
        const int HIRS_HOT = 2;
        const int HIRS_PRESSED = 3;
    const int HP_HEADERSORTARROW = 4;
        const int HSAS_SORTEDUP = 1;
        const int HSAS_SORTEDDOWN = 2;

    // "ListView" Parts & States - LISTVIEW
    const int LVP_LISTITEM = 1;
        const int LIS_NORMAL = 1;
        const int LIS_HOT = 2;
        const int LIS_SELECTED = 3;
        const int LIS_DISABLED = 4;
        const int LIS_SELECTEDNOTFOCUS = 5;
    const int LVP_LISTGROUP = 2;
    const int LVP_LISTDETAIL = 3;
    const int LVP_LISTSORTEDDETAIL = 4;
    const int LVP_EMPTYTEXT = 5;

    //   "Menu" Parts & States - MENU
    const int MP_MENUITEM = 1;
        const int MS_NORMAL = 1;
        const int MS_SELECTED = 2;
        const int MS_DEMOTED = 3;
    const int MP_MENUDROPDOWN = 2;
        // same as above
    const int MP_MENUBARITEM = 3;
        // same as above
    const int MP_MENUBARDROPDOWN = 4;
        // same as above
    const int MP_CHEVRON = 5;
        // same as above
    const int MP_SEPARATOR = 6;
        // same as above

    //   "TaskBand" Parts & States - MENUBAND
    const int MDP_NEWAPPBUTTON = 1;
        const int MDS_NORMAL = 1;
        const int MDS_HOT = 2;
        const int MDS_PRESSED = 3;
        const int MDS_DISABLED = 4;
        const int MDS_CHECKED = 5;
        const int MDS_HOTCHECKED = 6;
    const int MDP_SEPARATOR = 2;

    // "Page" Parts & States - PAGE
   const int PGRP_UP = 1;
   const int PGRP_DOWN = 2;
   const int PGRP_UPHORZ = 3;
   const int PGRP_DOWNHORZ = 4;
    //--- Pager uses same states as Spin ---

    //   "Progress" Parts & States - PROGRESS
    const int PP_BAR = 1;
    const int PP_BARVERT = 2;
    const int PP_CHUNK = 3;
    const int PP_CHUNKVERT = 4;
   
    //   "Rebar" Parts & States - REBAR
    const int RP_GRIPPER = 1;
    const int RP_GRIPPERVERT = 2;
    const int RP_BAND = 3;
    const int RP_CHEVRON = 4;
        const int CHEVS_NORMAL = 1;
        const int CHEVS_HOT = 2;
        const int CHEVS_PRESSED = 3;
    const int RP_CHEVRONVERT = 5;

    // "Scrollbar" Parts & States - SCROLLBAR
    const int SBP_ARROWBTN = 1;
        const int ABS_UPNORMAL = 1;
        const int ABS_UPHOT = 2;
        const int ABS_UPPRESSED = 3;
        const int ABS_UPDISABLED = 4;
        const int ABS_DOWNNORMAL = 5;
        const int ABS_DOWNHOT = 6;
        const int ABS_DOWNPRESSED = 7;
        const int ABS_DOWNDISABLED = 8;
        const int ABS_LEFTNORMAL = 9;
        const int ABS_LEFTHOT = 10;
        const int ABS_LEFTPRESSED = 11;
        const int ABS_LEFTDISABLED = 12;
        const int ABS_RIGHTNORMAL = 13;
        const int ABS_RIGHTHOT = 14;
        const int ABS_RIGHTPRESSED = 15;
        const int ABS_RIGHTDISABLED = 16;
    const int SBP_THUMBBTNHORZ = 2;
        const int SCRBS_NORMAL = 1;
        const int SCRBS_HOT = 2;
        const int SCRBS_PRESSED = 3;
        const int SCRBS_DISABLED = 4;
    const int SBP_THUMBBTNVERT = 3;
        // same as SBP_THUMBBTNHORZ
    const int SBP_LOWERTRACKHORZ = 4;
        // same as SBP_THUMBBTNHORZ
    const int SBP_UPPERTRACKHORZ = 5;
        // same as SBP_THUMBBTNHORZ
    const int SBP_LOWERTRACKVERT = 6;
        // same as SBP_THUMBBTNHORZ
    const int SBP_UPPERTRACKVERT = 7;
        // same as SBP_THUMBBTNHORZ
    const int SBP_GRIPPERHORZ = 8;
    const int SBP_GRIPPERVERT = 9;
    const int SBP_SIZEBOX = 10;
        const int SZB_RIGHTALIGN = 1;
        const int SZB_LEFTALIGN = 2;

    // "Spin" Parts & States - SPIN
    const int SPNP_UP = 1;
        const int UPS_NORMAL = 1;
        const int UPS_HOT = 2;
        const int UPS_PRESSED = 3;
        const int UPS_DISABLED = 4;
    const int SPNP_DOWN = 2;
        const int DNS_NORMAL = 1;
        const int DNS_HOT = 2;
        const int DNS_PRESSED = 3;
        const int DNS_DISABLED = 4;
    const int SPNP_UPHORZ = 3;
        const int UPHZS_NORMAL = 1;
        const int UPHZS_HOT = 2;
        const int UPHZS_PRESSED = 3;
        const int UPHZS_DISABLED = 4;
    const int SPNP_DOWNHORZ = 4;
        const int DNHZS_NORMAL = 1;
        const int DNHZS_HOT = 2;
        const int DNHZS_PRESSED = 3;
        const int DNHZS_DISABLED = 4;

    // "StartPanel" Parts & States - STARTPANEL
    const int SPP_USERPANE = 1;
    const int SPP_MOREPROGRAMS = 2;
    const int SPP_MOREPROGRAMSARROW = 3;
        const int SPS_NORMAL = 1;
        const int SPS_HOT = 2;
        const int SPS_PRESSED = 3;
    const int SPP_PROGLIST = 4;
    const int SPP_PROGLISTSEPARATOR = 5;
    const int SPP_PLACESLIST = 6;
    const int SPP_PLACESLISTSEPARATOR = 7;
    const int SPP_LOGOFF = 8;
    const int SPP_LOGOFFBUTTONS = 9;
        const int SPLS_NORMAL = 1;
        const int SPLS_HOT = 2;
        const int SPLS_PRESSED = 3;
    const int SPP_USERPICTURE = 10;
    const int SPP_PREVIEW = 11;

    //   "Status" Parts & States - STATUS
    const int SP_PANE = 1;
    const int SP_GRIPPERPANE = 2;
    const int SP_GRIPPER = 3;

    // "Tab" Parts & States - TAB
    const int TABP_TABITEM = 1;
        const int TIS_NORMAL = 1;
        const int TIS_HOT = 2;
        const int TIS_SELECTED = 3;
        const int TIS_DISABLED = 4;
        const int TIS_FOCUSED = 5;
    const int TABP_TABITEMLEFTEDGE = 2;
        const int TILES_NORMAL = 1;
        const int TILES_HOT = 2;
        const int TILES_SELECTED = 3;
        const int TILES_DISABLED = 4;
        const int TILES_FOCUSED = 5;
    const int TABP_TABITEMRIGHTEDGE = 3;
        const int TIRES_NORMAL = 1;
        const int TIRES_HOT = 2;
        const int TIRES_SELECTED = 3;
        const int TIRES_DISABLED = 4;
        const int TIRES_FOCUSED = 5;
    const int TABP_TABITEMBOTHEDGE = 4;
        const int TIBES_NORMAL = 1;
        const int TIBES_HOT = 2;
        const int TIBES_SELECTED = 3;
        const int TIBES_DISABLED = 4;
        const int TIBES_FOCUSED = 5;
    const int TABP_TOPTABITEM = 5;
        const int TTIS_NORMAL = 1;
        const int TTIS_HOT = 2;
        const int TTIS_SELECTED = 3;
        const int TTIS_DISABLED = 4;
        const int TTIS_FOCUSED = 5;
    const int TABP_TOPTABITEMLEFTEDGE = 6;
        const int TTILES_NORMAL = 1;
        const int TTILES_HOT = 2;
        const int TTILES_SELECTED = 3;
        const int TTILES_DISABLED = 4;
        const int TTILES_FOCUSED = 5;
    const int TABP_TOPTABITEMRIGHTEDGE = 7;
        const int TTIRES_NORMAL = 1;
        const int TTIRES_HOT = 2;
        const int TTIRES_SELECTED = 3;
        const int TTIRES_DISABLED = 4;
        const int TTIRES_FOCUSED = 5;
    const int TABP_TOPTABITEMBOTHEDGE = 8;
        const int TTIBES_NORMAL = 1;
        const int TTIBES_HOT = 2;
        const int TTIBES_SELECTED = 3;
        const int TTIBES_DISABLED = 4;
        const int TTIBES_FOCUSED = 5;
    const int TABP_PANE = 9;
    const int TABP_BODY = 10;

    // "TaskBand" Parts & States - TASKBAND
    const int TDP_GROUPCOUNT = 1;
    const int TDP_FLASHBUTTON = 2;
    const int TDP_FLASHBUTTONGROUPMENU = 3;

    //   "TaskBar" Parts & States - TASKBAR
    const int TBP_BACKGROUNDBOTTOM = 1;
    const int TBP_BACKGROUNDRIGHT = 2;
    const int TBP_BACKGROUNDTOP = 3;
    const int TBP_BACKGROUNDLEFT = 4;
    const int TBP_SIZINGBARBOTTOM = 5;
    const int TBP_SIZINGBARRIGHT = 6;
    const int TBP_SIZINGBARTOP = 7;
    const int TBP_SIZINGBARLEFT = 8;

    // "Toolbar" Parts & States - TOOLBAR
    const int TP_BUTTON = 1;
        const int TS_NORMAL = 1;
        const int TS_HOT = 2;
        const int TS_PRESSED = 3;
        const int TS_DISABLED = 4;
        const int TS_CHECKED = 5;
        const int TS_HOTCHECKED = 6;
    const int TP_DROPDOWNBUTTON = 2;
        // same as above
    const int TP_SPLITBUTTON = 3;
        // same as above
    const int TP_SPLITBUTTONDROPDOWN = 4;
        // same as above
    const int TP_SEPARATOR = 5;
        // same as above
    const int TP_SEPARATORVERT = 6;
        // same as above

    // "Tooltips" Parts & States - TOOLTIP
    const int TTP_STANDARD = 1;
        const int TTSS_NORMAL = 1;
        const int TTSS_LINK = 2;
    const int TTP_STANDARDTITLE = 2;
        // same as TTP_STANDARD
    const int TTP_BALLOON = 3;
        const int TTBS_NORMAL = 1;
        const int TTBS_LINK = 2;
    const int TTP_BALLOONTITLE = 4;
        // same as TTP_BALLOON
    const int TTP_CLOSE = 5;
        const int TTCS_NORMAL = 1;
        const int TTCS_HOT = 2;
        const int TTCS_PRESSED = 3;

    //   "Trackbar" Parts & States - TRACKBAR
    const int TKP_TRACK = 1;
        const int TRS_NORMAL = 1;
    const int TKP_TRACKVERT = 2;
        const int TRVS_NORMAL = 1;
    const int TKP_THUMB = 3;
        const int TUS_NORMAL = 1;
        const int TUS_HOT = 2;
        const int TUS_PRESSED = 3;
        const int TUS_FOCUSED = 4;
        const int TUS_DISABLED = 5;
    const int TKP_THUMBBOTTOM = 4;
        const int TUBS_NORMAL = 1;
        const int TUBS_HOT = 2;
        const int TUBS_PRESSED = 3;
        const int TUBS_FOCUSED = 4;
        const int TUBS_DISABLED = 5;
    const int TKP_THUMBTOP = 5;
        const int TUTS_NORMAL = 1;
        const int TUTS_HOT = 2;
        const int TUTS_PRESSED = 3;
        const int TUTS_FOCUSED = 4;
        const int TUTS_DISABLED = 5;
    const int TKP_THUMBVERT = 6;
        const int TUVS_NORMAL = 1;
        const int TUVS_HOT = 2;
        const int TUVS_PRESSED = 3;
        const int TUVS_FOCUSED = 4;
        const int TUVS_DISABLED = 5;
    const int TKP_THUMBLEFT = 7;
        const int TUVLS_NORMAL = 1;
        const int TUVLS_HOT = 2;
        const int TUVLS_PRESSED = 3;
        const int TUVLS_FOCUSED = 4;
        const int TUVLS_DISABLED = 5;
    const int TKP_THUMBRIGHT = 8;
        const int TUVRS_NORMAL = 1;
        const int TUVRS_HOT = 2;
        const int TUVRS_PRESSED = 3;
        const int TUVRS_FOCUSED = 4;
        const int TUVRS_DISABLED = 5;
    const int TKP_TICS = 9;
        const int TSS_NORMAL = 1;
    const int TKP_TICSVERT = 10;
        const int TSVS_NORMAL = 1;

    //   "Tray Notify" Parts & States - TRAYNOTIFY
    const int TNP_BACKGROUND = 1;
    const int TNP_ANIMBACKGROUND = 2;

    //   "TreeView" Parts & States - TREEVIEW
    const int TVP_TREEITEM = 1;
        const int TREIS_NORMAL = 1;
        const int TREIS_HOT = 2;
        const int TREIS_SELECTED = 3;
        const int TREIS_DISABLED = 4;
        const int TREIS_SELECTEDNOTFOCUS = 5;
    const int TVP_GLYPH = 2;
        const int GLPS_CLOSED = 1;
        const int GLPS_OPENED = 2;
    const int TVP_BRANCH = 3;

    //   "Window" (i.e., non-client) Parts & States - WINDOW
    const int WP_CAPTION = 1;
        const int CS_ACTIVE = 1;
        const int CS_INACTIVE = 2;
        const int CS_DISABLED = 3;
    const int WP_SMALLCAPTION = 2;
        // same as WP_CAPTION
    const int WP_MINCAPTION = 3;
        const int MNCS_ACTIVE = 1;
        const int MNCS_INACTIVE = 2;
        const int MNCS_DISABLED = 3;
    const int WP_SMALLMINCAPTION = 4;
        // same as WP_MINCAPTION
    const int WP_MAXCAPTION = 5;
        const int MXCS_ACTIVE = 1;
        const int MXCS_INACTIVE = 2;
        const int MXCS_DISABLED = 3;
    const int WP_SMALLMAXCAPTION = 6;
        // same as WP_MAXCAPTION
    const int WP_FRAMELEFT = 7;
        const int FS_ACTIVE = 1;
        const int FS_INACTIVE = 2;
    const int WP_FRAMERIGHT = 8;
        // same as WP_FRAMELEFT
    const int WP_FRAMEBOTTOM = 9;
        // same as WP_FRAMELEFT
    const int WP_SMALLFRAMELEFT = 10;
        // same as WP_FRAMELEFT
    const int WP_SMALLFRAMERIGHT = 11;
        // same as WP_FRAMELEFT
    const int WP_SMALLFRAMEBOTTOM = 12;
        // same as WP_FRAMELEFT
    //---- window frame buttons ----
    const int WP_SYSBUTTON = 13;
        const int SBS_NORMAL = 1;
        const int SBS_HOT = 2;
        const int SBS_PUSHED = 3;
        const int SBS_DISABLED = 4;
    const int WP_MDISYSBUTTON = 14;
        // same as WP_SYSBUTTON
    const int WP_MINBUTTON = 15;
        const int MINBS_NORMAL = 1;
        const int MINBS_HOT = 2;
        const int MINBS_PUSHED = 3;
        const int MINBS_DISABLED = 4;
    const int WP_MDIMINBUTTON = 16;
        // same as WP_MINBUTTON
    const int WP_MAXBUTTON = 17;
        const int MAXBS_NORMAL = 1;
        const int MAXBS_HOT = 2;
        const int MAXBS_PUSHED = 3;
        const int MAXBS_DISABLED = 4;
    const int WP_CLOSEBUTTON = 18;
        const int CBS_NORMAL = 1;
        const int CBS_HOT = 2;
        const int CBS_PUSHED = 3;
        const int CBS_DISABLED = 4;
    const int WP_SMALLCLOSEBUTTON = 19;
        // same as WP_CLOSEBUTTON
    const int WP_MDICLOSEBUTTON = 20;
        // same as WP_CLOSEBUTTON
    const int WP_RESTOREBUTTON = 21;
        const int RBS_NORMAL = 1;
        const int RBS_HOT = 2;
        const int RBS_PUSHED = 3;
        const int RBS_DISABLED = 4;
    const int WP_MDIRESTOREBUTTON = 22;
        // same as WP_RESTOREBUTTON
    const int WP_HELPBUTTON = 23;
        const int HBS_NORMAL = 1;
        const int HBS_HOT = 2;
        const int HBS_PUSHED = 3;
        const int HBS_DISABLED = 4;
    const int WP_MDIHELPBUTTON = 24;
        // same as WP_HELPBUTTON
    //---- scrollbars 
    const int WP_HORZSCROLL = 25;
        const int HSS_NORMAL = 1;
        const int HSS_HOT = 2;
        const int HSS_PUSHED = 3;
        const int HSS_DISABLED = 4;
    const int WP_HORZTHUMB = 26;
        const int HTS_NORMAL = 1;
        const int HTS_HOT = 2;
        const int HTS_PUSHED = 3;
        const int HTS_DISABLED = 4;
    const int WP_VERTSCROLL = 27;
        const int VSS_NORMAL = 1;
        const int VSS_HOT = 2;
        const int VSS_PUSHED = 3;
        const int VSS_DISABLED = 4;
    const int WP_VERTTHUMB = 28;
        const int VTS_NORMAL = 1;
        const int VTS_HOT = 2;
        const int VTS_PUSHED = 3;
        const int VTS_DISABLED = 4;
    //---- dialog ----
    const int WP_DIALOG = 29;
    //---- hit-test templates ---
    const int WP_CAPTIONSIZINGTEMPLATE = 30;
    const int WP_SMALLCAPTIONSIZINGTEMPLATE = 31;
    const int WP_FRAMELEFTSIZINGTEMPLATE = 32;
    const int WP_SMALLFRAMELEFTSIZINGTEMPLATE = 33;
    const int WP_FRAMERIGHTSIZINGTEMPLATE = 34;
    const int WP_SMALLFRAMERIGHTSIZINGTEMPLATE = 35;
    const int WP_FRAMEBOTTOMSIZINGTEMPLATE = 36;
    const int WP_SMALLFRAMEBOTTOMSIZINGTEMPLATE = 37;

    //---- primitive types ----
    const int TMT_STRING = 201; // STRING
    const int TMT_INT = 202; // INT
    const int TMT_BOOL = 203; // _BOOL
    const int TMT_COLOR = 204; // COLOR
    const int TMT_MARGINS = 205; // MARGINS
    const int TMT_FILENAME = 206; // FILENAME
    const int TMT_SIZE = 207; // SIZE
    const int TMT_POSITION = 208; // POSITION
    const int TMT_RECT = 209; // _RECT
    const int TMT_FONT = 210; // FONT
    const int TMT_INTLIST = 211; // INTLIST

    //---- special misc. properties ----
    const int TMT_COLORSCHEMES = 401; // STRING
    const int TMT_SIZES = 402; // STRING
    const int TMT_CHARSET = 403; // INT

    //---- [documentation] properties ----
    const int TMT_DISPLAYNAME = 601; // STRING
    const int TMT_TOOLTIP = 602; // STRING
    const int TMT_COMPANY = 603; // STRING
    const int TMT_AUTHOR = 604; // STRING
    const int TMT_COPYRIGHT = 605; // STRING
    const int TMT_URL = 606; // STRING
    const int TMT_VERSION = 607; // STRING
    const int TMT_DESCRIPTION = 608; // STRING

    //---- theme metrics: fonts ----
    const int TMT_CAPTIONFONT = 801; // FONT
    const int TMT_SMALLCAPTIONFONT = 802; // FONT
    const int TMT_MENUFONT = 803; // FONT
    const int TMT_STATUSFONT = 804; // FONT
    const int TMT_MSGBOXFONT = 805; // FONT
    const int TMT_ICONTITLEFONT = 806; // FONT

    //---- theme metrics: bools ----
    const int TMT_FLATMENUS = 1001; // _BOOL

    //---- theme metrics: sizes ----
    const int TMT_SIZINGBORDERWIDTH = 1201; // SIZE
    const int TMT_SCROLLBARWIDTH = 1202; // SIZE
    const int TMT_SCROLLBARHEIGHT = 1203; // SIZE
    const int TMT_CAPTIONBARWIDTH = 1204; // SIZE
    const int TMT_CAPTIONBARHEIGHT = 1205; // SIZE
    const int TMT_SMCAPTIONBARWIDTH = 1206; // SIZE
    const int TMT_SMCAPTIONBARHEIGHT = 1207; // SIZE
    const int TMT_MENUBARWIDTH = 1208; // SIZE
    const int TMT_MENUBARHEIGHT = 1209; // SIZE

    //---- theme metrics: ints ----
    const int TMT_MINCOLORDEPTH = 1301; // INT

    //---- theme metrics: strings ----
    const int TMT_CSSNAME = 1401; // STRING
    const int TMT_XMLNAME = 1402; // STRING

    //---- theme metrics: colors ----
    const int TMT_SCROLLBAR = 1601; // COLOR
    const int TMT_BACKGROUND = 1602; // COLOR
    const int TMT_ACTIVECAPTION = 1603; // COLOR
    const int TMT_INACTIVECAPTION = 1604; // COLOR
    const int TMT_MENU = 1605; // COLOR
    const int TMT_WINDOW = 1606; // COLOR
    const int TMT_WINDOWFRAME = 1607; // COLOR
    const int TMT_MENUTEXT = 1608; // COLOR
    const int TMT_WINDOWTEXT = 1609; // COLOR
    const int TMT_CAPTIONTEXT = 1610; // COLOR
    const int TMT_ACTIVEBORDER = 1611; // COLOR
    const int TMT_INACTIVEBORDER = 1612; // COLOR
    const int TMT_APPWORKSPACE = 1613; // COLOR
    const int TMT_HIGHLIGHT = 1614; // COLOR
    const int TMT_HIGHLIGHTTEXT = 1615; // COLOR
    const int TMT_BTNFACE = 1616; // COLOR
    const int TMT_BTNSHADOW = 1617; // COLOR
    const int TMT_GRAYTEXT = 1618; // COLOR
    const int TMT_BTNTEXT = 1619; // COLOR
    const int TMT_INACTIVECAPTIONTEXT = 1620; // COLOR
    const int TMT_BTNHIGHLIGHT = 1621; // COLOR
    const int TMT_DKSHADOW3D = 1622; // COLOR
    const int TMT_LIGHT3D = 1623; // COLOR
    const int TMT_INFOTEXT = 1624; // COLOR
    const int TMT_INFOBK = 1625; // COLOR
    const int TMT_BUTTONALTERNATEFACE = 1626; // COLOR
    const int TMT_HOTTRACKING = 1627; // COLOR
    const int TMT_GRADIENTACTIVECAPTION = 1628; // COLOR
    const int TMT_GRADIENTINACTIVECAPTION = 1629; // COLOR
    const int TMT_MENUHILIGHT = 1630; // COLOR
    const int TMT_MENUBAR = 1631; // COLOR

    //---- hue substitutions ----
    const int TMT_FROMHUE1 = 1801; // INT
    const int TMT_FROMHUE2 = 1802; // INT
    const int TMT_FROMHUE3 = 1803; // INT
    const int TMT_FROMHUE4 = 1804; // INT
    const int TMT_FROMHUE5 = 1805; // INT
    const int TMT_TOHUE1 = 1806; // INT
    const int TMT_TOHUE2 = 1807; // INT
    const int TMT_TOHUE3 = 1808; // INT
    const int TMT_TOHUE4 = 1809; // INT
    const int TMT_TOHUE5 = 1810; // INT

    //---- color substitutions ----
    const int TMT_FROMCOLOR1 = 2001; // COLOR
    const int TMT_FROMCOLOR2 = 2002; // COLOR
    const int TMT_FROMCOLOR3 = 2003; // COLOR
    const int TMT_FROMCOLOR4 = 2004; // COLOR
    const int TMT_FROMCOLOR5 = 2005; // COLOR
    const int TMT_TOCOLOR1 = 2006; // COLOR
    const int TMT_TOCOLOR2 = 2007; // COLOR
    const int TMT_TOCOLOR3 = 2008; // COLOR
    const int TMT_TOCOLOR4 = 2009; // COLOR
    const int TMT_TOCOLOR5 = 2010; // COLOR

    //---- rendering _BOOL properties ----
    const int TMT_TRANSPARENT = 2201; // _BOOL - image has transparent areas (see TransparentColor)
    const int TMT_AUTOSIZE = 2202; // _BOOL - if TRUE, nonclient caption width varies with text extent
    const int TMT_BORDERONLY = 2203; // _BOOL - only draw the border area of the image
    const int TMT_COMPOSITED = 2204; // _BOOL - control will handle the composite drawing
    const int TMT_BGFILL = 2205; // _BOOL - if TRUE, TRUESIZE images should be drawn on bg fill
    const int TMT_GLYPHTRANSPARENT = 2206; // _BOOL - glyph has transparent areas (see GlyphTransparentColor)
    const int TMT_GLYPHONLY = 2207; // _BOOL - only draw glyph (not background)
    const int TMT_ALWAYSSHOWSIZINGBAR = 2208; // _BOOL -
    const int TMT_MIRRORIMAGE = 2209; // _BOOL - default=TRUE means image gets mirrored in RTL (Mirror) windows
    const int TMT_UNIFORMSIZING = 2210; // _BOOL - if TRUE, height & width must be uniformly sized 
    const int TMT_INTEGRALSIZING = 2211; // _BOOL - for TRUESIZE and Border sizing; if TRUE, factor must be integer
    const int TMT_SOURCEGROW = 2212; // _BOOL - if TRUE, will scale up src image when needed
    const int TMT_SOURCESHRINK = 2213; // _BOOL - if TRUE, will scale down src image when needed

    //---- rendering INT properties ----
    const int TMT_IMAGECOUNT = 2401; // INT - the number of state images in an imagefile
    const int TMT_ALPHALEVEL = 2402; // INT - (0-255) alpha value for an icon (DrawThemeIcon part)
    const int TMT_BORDERSIZE = 2403; // INT - the size of the border line for bgtype=BorderFill
    const int TMT_ROUNDCORNERWIDTH = 2404; // INT - (0-100) % of roundness for rounded rects
    const int TMT_ROUNDCORNERHEIGHT = 2405; // INT - (0-100) % of roundness for rounded rects
    const int TMT_GRADIENTRATIO1 = 2406; // INT - (0-255) - amt of gradient color 1 to use (all must total=255)
    const int TMT_GRADIENTRATIO2 = 2407; // INT - (0-255) - amt of gradient color 2 to use (all must total=255)
    const int TMT_GRADIENTRATIO3 = 2408; // INT - (0-255) - amt of gradient color 3 to use (all must total=255)
    const int TMT_GRADIENTRATIO4 = 2409; // INT - (0-255) - amt of gradient color 4 to use (all must total=255)
    const int TMT_GRADIENTRATIO5 = 2410; // INT - (0-255) - amt of gradient color 5 to use (all must total=255)
    const int TMT_PROGRESSCHUNKSIZE = 2411; // INT - size of progress control chunks
    const int TMT_PROGRESSSPACESIZE = 2412; // INT - size of progress control spaces
    const int TMT_SATURATION = 2413; // INT - (0-255) amt of saturation for DrawThemeIcon() part
    const int TMT_TEXTBORDERSIZE = 2414; // INT - size of border around text chars
    const int TMT_ALPHATHRESHOLD = 2415; // INT - (0-255) the min. alpha value of a pixel that is solid
    const int TMT_WIDTH = 2416; // SIZE - custom window prop: size of part (min. window)
    const int TMT_HEIGHT = 2417; // SIZE - custom window prop: size of part (min. window)
    const int TMT_GLYPHINDEX = 2418; // INT - for font-based glyphs, the char index into the font
    const int TMT_TRUESIZESTRETCHMARK = 2419; // INT - stretch TrueSize image when target exceeds source by this percent
    const int TMT_MINDPI1 = 2420; // INT - min DPI ImageFile1 was designed for
    const int TMT_MINDPI2 = 2421; // INT - min DPI ImageFile1 was designed for
    const int TMT_MINDPI3 = 2422; // INT - min DPI ImageFile1 was designed for
    const int TMT_MINDPI4 = 2423; // INT - min DPI ImageFile1 was designed for
    const int TMT_MINDPI5 = 2424; // INT - min DPI ImageFile1 was designed for

    //---- rendering FONT properties ----
    const int TMT_GLYPHFONT = 2601; // FONT - the font that the glyph is drawn with

    //---- rendering FILENAME properties ----
    const int TMT_IMAGEFILE = 3001; // FILENAME - the filename of the image (or basename, for mult. images)
    const int TMT_IMAGEFILE1 = 3002; // FILENAME - multiresolution image file
    const int TMT_IMAGEFILE2 = 3003; // FILENAME - multiresolution image file
    const int TMT_IMAGEFILE3 = 3004; // FILENAME - multiresolution image file
    const int TMT_IMAGEFILE4 = 3005; // FILENAME - multiresolution image file
    const int TMT_IMAGEFILE5 = 3006; // FILENAME - multiresolution image file
    const int TMT_STOCKIMAGEFILE = 3007; // FILENAME - These are the only images that you can call GetThemeBitmap on
    const int TMT_GLYPHIMAGEFILE = 3008; // FILENAME - the filename for the glyph image

    //---- rendering MARGIN properties ----
    const int TMT_SIZINGMARGINS = 3601; // MARGINS - margins used for 9-grid sizing
    const int TMT_CONTENTMARGINS = 3602; // MARGINS - margins that define where content can be placed
    const int TMT_CAPTIONMARGINS = 3603; // MARGINS - margins that define where caption text can be placed

    //---- rendering COLOR properties ----
    const int TMT_BORDERCOLOR = 3801; // COLOR - color of borders for BorderFill 
    const int TMT_FILLCOLOR = 3802; // COLOR - color of bg fill 
    const int TMT_TEXTCOLOR = 3803; // COLOR - color text is drawn in
    const int TMT_EDGELIGHTCOLOR = 3804; // COLOR - edge color
    const int TMT_EDGEHIGHLIGHTCOLOR = 3805; // COLOR - edge color
    const int TMT_EDGESHADOWCOLOR = 3806; // COLOR - edge color
    const int TMT_EDGEDKSHADOWCOLOR = 3807; // COLOR - edge color
    const int TMT_EDGEFILLCOLOR = 3808; // COLOR - edge color
    const int TMT_TRANSPARENTCOLOR = 3809; // COLOR - color of pixels that are treated as transparent (not drawn)
    const int TMT_GRADIENTCOLOR1 = 3810; // COLOR - first color in gradient
    const int TMT_GRADIENTCOLOR2 = 3811; // COLOR - second color in gradient
    const int TMT_GRADIENTCOLOR3 = 3812; // COLOR - third color in gradient
    const int TMT_GRADIENTCOLOR4 = 3813; // COLOR - forth color in gradient
    const int TMT_GRADIENTCOLOR5 = 3814; // COLOR - fifth color in gradient
    const int TMT_SHADOWCOLOR = 3815; // COLOR - color of text shadow
    const int TMT_GLOWCOLOR = 3816; // COLOR - color of glow produced by DrawThemeIcon
    const int TMT_TEXTBORDERCOLOR = 3817; // COLOR - color of text border
    const int TMT_TEXTSHADOWCOLOR = 3818; // COLOR - color of text shadow
    const int TMT_GLYPHTEXTCOLOR = 3819; // COLOR - color that font-based glyph is drawn with
    const int TMT_GLYPHTRANSPARENTCOLOR = 3820; // COLOR - color of transparent pixels in GlyphImageFile
    const int TMT_FILLCOLORHINT = 3821; // COLOR - hint about fill color used (for custom controls)
    const int TMT_BORDERCOLORHINT = 3822; // COLOR - hint about border color used (for custom controls)
    const int TMT_ACCENTCOLORHINT = 3823; // COLOR - hint about accent color used (for custom controls)

    //---- rendering enum properties (must be declared in TM_ENUM section above) ----
    const int TMT_BGTYPE = 4001; // ENUM - basic drawing type for each part
    const int TMT_BORDERTYPE = 4002; // ENUM - type of border for BorderFill parts
    const int TMT_FILLTYPE = 4003; // ENUM - fill shape for BorderFill parts
    const int TMT_SIZINGTYPE = 4004; // ENUM - how to size ImageFile parts
    const int TMT_HALIGN = 4005; // ENUM - horizontal alignment for TRUESIZE parts & glyphs
    const int TMT_CONTENTALIGNMENT = 4006; // ENUM - custom window prop: how text is aligned in caption
    const int TMT_VALIGN = 4007; // ENUM - horizontal alignment for TRUESIZE parts & glyphs
    const int TMT_OFFSETTYPE = 4008; // ENUM - how window part should be placed
    const int TMT_ICONEFFECT = 4009; // ENUM - type of effect to use with DrawThemeIcon
    const int TMT_TEXTSHADOWTYPE = 4010; // ENUM - type of shadow to draw with text
    const int TMT_IMAGELAYOUT = 4011; // ENUM - how multiple images are arranged (horz. or vert.)
    const int TMT_GLYPHTYPE = 4012; // ENUM - controls type of glyph in imagefile objects
    const int TMT_IMAGESELECTTYPE = 4013; // ENUM - controls when to select from IMAGEFILE1...IMAGEFILE5
    const int TMT_GLYPHFONTSIZINGTYPE = 4014; // ENUM - controls when to select a bigger/small glyph font size
    const int TMT_TRUESIZESCALINGTYPE = 4015; // ENUM - controls how TrueSize image is scaled
    
    //---- custom properties (used only by controls/shell) ----
    const int TMT_USERPICTURE = 5001; // _BOOL
    const int TMT_DEFAULTPANESIZE = 5002; // _RECT
    const int TMT_BLENDCOLOR = 5003; // COLOR

    char [] getCurrentThemeFileName ()
    {
        if (GetCurrentThemeName === null)
            return null;

        wchar [1024] result;

        int error = GetCurrentThemeName (result, result.length, null, 0, null, 0);

        if (error)
            digPlatformGetLastError ("getCurrentThemeFileName", error);

        return wtoStringz ((wchar *) result);
    }

    char [] [] controlNames =
    [
        "Button",
        "Clock",
        "ComboBox",
        "Edit",
        "ExplorerBar",
        "Globals",
        "Header",
        "ListView",
        "Menu",
        "MenuBand",
        "Page",
        "Progress",
        "Rebar",
        "ScrollBar",
        "Spin",
        "StartPanel",
        "Status",
        "Tab",
        "TaskBand",
        "TaskBar",
        "ToolBar",
        "ToolTip",
        "TrackBar",
        "TrayNotify",
        "TreeView",
        "Window",
    ];

    int [] controlParts (char [] name)
    {
        if (!std.string.icmp (name, "Button")) { const int [] list173 = [ BP_CHECKBOX, BP_GROUPBOX, BP_PUSHBUTTON, BP_USERBUTTON ]; return list173; }
        if (!std.string.icmp (name, "Clock")) { const int [] list174 = [ CLP_TIME ]; return list174; }
        if (!std.string.icmp (name, "ComboBox")) { const int [] list175 = [ CP_DROPDOWNBUTTON ]; return list175; }
        if (!std.string.icmp (name, "Edit")) { const int [] list176 = [ EP_CARET, EP_EDITTEXT ]; return list176; }
        if (!std.string.icmp (name, "ExplorerBar")) { const int [] list177 = [ EBP_HEADERBACKGROUND, EBP_HEADERCLOSE, EBP_HEADERPIN, EBP_IEBARMENU, EBP_NORMALGROUPBACKGROUND, EBP_NORMALGROUPCOLLAPSE, EBP_NORMALGROUPEXPAND, EBP_NORMALGROUPHEAD, EBP_SPECIALGROUPBACKGROUND, EBP_SPECIALGROUPCOLLAPSE, EBP_SPECIALGROUPEXPAND, EBP_SPECIALGROUPHEAD ]; return list177; }
        if (!std.string.icmp (name, "Globals")) { const int [] list178 = [ GP_BORDER, GP_LINEHORZ, GP_LINEVERT ]; return list178; }
        if (!std.string.icmp (name, "Header")) { const int [] list179 = [ HP_HEADERITEM, HP_HEADERITEMLEFT, HP_HEADERITEMRIGHT, HP_HEADERSORTARROW ]; return list179; }
        if (!std.string.icmp (name, "ListView")) { const int [] list180 = [ LVP_EMPTYTEXT, LVP_LISTDETAIL, LVP_LISTGROUP, LVP_LISTITEM, LVP_LISTSORTEDDETAIL ]; return list180; }
        if (!std.string.icmp (name, "Menu")) { const int [] list181 = [ MP_MENUBARDROPDOWN, MP_MENUBARITEM, MP_CHEVRON, MP_MENUDROPDOWN, MP_MENUITEM, MP_SEPARATOR ]; return list181; }
        if (!std.string.icmp (name, "MenuBand")) { const int [] list182 = [ MDP_NEWAPPBUTTON, MDP_SEPARATOR ]; return list182; }
        if (!std.string.icmp (name, "Page")) { const int [] list183 = [ PGRP_DOWN, PGRP_DOWNHORZ, PGRP_UP, PGRP_UPHORZ ]; return list183; }
        if (!std.string.icmp (name, "Progress")) { const int [] list184 = [ PP_BAR, PP_BARVERT, PP_CHUNK, PP_CHUNKVERT ]; return list184; }
        if (!std.string.icmp (name, "Rebar")) { const int [] list185 = [ RP_BAND, RP_CHEVRON, RP_CHEVRONVERT, RP_GRIPPER, RP_GRIPPERVERT ]; return list185; }
        if (!std.string.icmp (name, "ScrollBar")) { const int [] list186 = [ SBP_ARROWBTN, SBP_GRIPPERHORZ, SBP_GRIPPERVERT, SBP_LOWERTRACKHORZ, SBP_LOWERTRACKVERT, SBP_THUMBBTNHORZ, SBP_THUMBBTNVERT, SBP_UPPERTRACKHORZ, SBP_UPPERTRACKVERT, SBP_SIZEBOX ]; return list186; }
        if (!std.string.icmp (name, "Spin")) { const int [] list187 = [ SPNP_DOWN, SPNP_DOWNHORZ, SPNP_UP, SPNP_UPHORZ ]; return list187; }
        if (!std.string.icmp (name, "StartPanel")) { const int [] list188 = [ SPP_LOGOFF, SPP_LOGOFFBUTTONS, SPP_MOREPROGRAMS, SPP_MOREPROGRAMSARROW, SPP_PLACESLIST, SPP_PLACESLISTSEPARATOR, SPP_PREVIEW, SPP_PROGLIST, SPP_PROGLISTSEPARATOR, SPP_USERPANE, SPP_USERPICTURE ]; return list188; }
        if (!std.string.icmp (name, "Status")) { const int [] list189 = [ SP_GRIPPER, SP_PANE, SP_GRIPPERPANE ]; return list189; }
        if (!std.string.icmp (name, "Tab")) { const int [] list190 = [ TABP_BODY, TABP_PANE, TABP_TABITEM, TABP_TABITEMBOTHEDGE, TABP_TABITEMLEFTEDGE, TABP_TABITEMRIGHTEDGE, TABP_TOPTABITEM, TABP_TOPTABITEMBOTHEDGE, TABP_TOPTABITEMLEFTEDGE, TABP_TOPTABITEMRIGHTEDGE ]; return list190; }
        if (!std.string.icmp (name, "TaskBand")) { const int [] list191 = [ TDP_GROUPCOUNT, TDP_FLASHBUTTON, TDP_FLASHBUTTONGROUPMENU ]; return list191; }
        if (!std.string.icmp (name, "TaskBar")) { const int [] list192 = [ TBP_BACKGROUNDBOTTOM, TBP_BACKGROUNDLEFT, TBP_BACKGROUNDRIGHT, TBP_BACKGROUNDTOP, TBP_SIZINGBARBOTTOM, TBP_SIZINGBARLEFT, TBP_SIZINGBARRIGHT, TBP_SIZINGBARTOP ]; return list192; }
        if (!std.string.icmp (name, "ToolBar")) { const int [] list193 = [ TP_BUTTON, TP_DROPDOWNBUTTON, TP_SPLITBUTTON, TP_SPLITBUTTONDROPDOWN, TP_SEPARATOR, TP_SEPARATORVERT ]; return list193; }
        if (!std.string.icmp (name, "ToolTip")) { const int [] list194 = [ TTP_BALLOON, TTP_BALLOONTITLE, TTP_CLOSE, TTP_STANDARD, TTP_STANDARDTITLE ]; return list194; }
        if (!std.string.icmp (name, "TrackBar")) { const int [] list195 = [ TKP_THUMB, TKP_THUMBBOTTOM, TKP_THUMBLEFT, TKP_THUMBRIGHT, TKP_THUMBTOP, TKP_THUMBVERT, TKP_TICS, TKP_TICSVERT, TKP_TRACK, TKP_TRACKVERT ]; return list195; }
        if (!std.string.icmp (name, "TrayNotify")) { const int [] list196 = [ TNP_ANIMBACKGROUND, TNP_BACKGROUND ]; return list196; }
        if (!std.string.icmp (name, "TreeView")) { const int [] list197 = [ TVP_BRANCH, TVP_GLYPH, TVP_TREEITEM ]; return list197; }
        if (!std.string.icmp (name, "Window")) { const int [] list198 = [ WP_CAPTION, WP_CAPTIONSIZINGTEMPLATE, WP_CLOSEBUTTON, 
            WP_DIALOG, WP_FRAMEBOTTOM, WP_FRAMEBOTTOMSIZINGTEMPLATE, WP_FRAMELEFT, 
            WP_FRAMELEFTSIZINGTEMPLATE, WP_FRAMERIGHT, WP_FRAMERIGHTSIZINGTEMPLATE, WP_HELPBUTTON, 
            WP_HORZSCROLL, WP_HORZTHUMB, WP_MAXBUTTON, WP_MAXCAPTION, WP_MDICLOSEBUTTON, 
            WP_MDIHELPBUTTON, WP_MDIMINBUTTON, WP_MDIRESTOREBUTTON, WP_MDISYSBUTTON, WP_MINBUTTON, 
            WP_MINCAPTION, WP_RESTOREBUTTON, WP_SMALLCAPTION, WP_SMALLCAPTIONSIZINGTEMPLATE, 
            WP_SMALLCLOSEBUTTON, WP_SMALLFRAMEBOTTOM, WP_SMALLFRAMEBOTTOMSIZINGTEMPLATE, 
            WP_SMALLFRAMELEFT, WP_SMALLFRAMELEFTSIZINGTEMPLATE, WP_SMALLFRAMERIGHT, 
            WP_SMALLFRAMERIGHTSIZINGTEMPLATE, 
            WP_SMALLMAXCAPTION, WP_SMALLMINCAPTION, 
            WP_SYSBUTTON, WP_VERTSCROLL, WP_VERTTHUMB ]; return list198; }
        throw new Error ("controlParts " ~ name);
    }

    private char [] findItem (char [] [] list, int part, int [] values) { for (int c; c < values.length; c ++) if (part == values [c]) return list [c]; }

    char [] [] controlPartNames (char [] name)
    {
        int [] list = controlParts (name);
        char [] [] result = new char [] [list.length];

        for (int c; c < result.length; c ++)
            result [c] = controlPartName (name, list [c]);
        return result;
    }

    char [] controlPartName (char [] name, int part)
    {
        if (!std.string.icmp (name, "Button")) { const char [] [] list147 = [ "BP_CHECKBOX", "BP_GROUPBOX", "BP_PUSHBUTTON", "BP_USERBUTTON" ]; return findItem (list147, part, controlParts (name)); }
        if (!std.string.icmp (name, "Clock")) { const char [] [] list148 = [ "CLP_TIME" ]; return findItem (list148, part, controlParts (name)); }
        if (!std.string.icmp (name, "ComboBox")) { const char [] [] list149 = [ "CP_DROPDOWNBUTTON" ]; return findItem (list149, part, controlParts (name)); }
        if (!std.string.icmp (name, "Edit")) { const char [] [] list150 = [ "EP_CARET", "EP_EDITTEXT" ]; return findItem (list150, part, controlParts (name)); }
        if (!std.string.icmp (name, "ExplorerBar")) { const char [] [] list151 = [ "EBP_HEADERBACKGROUND", "EBP_HEADERCLOSE", "EBP_HEADERPIN", "EBP_IEBARMENU", "EBP_NORMALGROUPBACKGROUND", "EBP_NORMALGROUPCOLLAPSE", "EBP_NORMALGROUPEXPAND", "EBP_NORMALGROUPHEAD", "EBP_SPECIALGROUPBACKGROUND", "EBP_SPECIALGROUPCOLLAPSE", "EBP_SPECIALGROUPEXPAND", "EBP_SPECIALGROUPHEAD" ]; return findItem (list151, part, controlParts (name)); }
        if (!std.string.icmp (name, "Globals")) { const char [] [] list152 = [ "GP_BORDER", "GP_LINEHORZ", "GP_LINEVERT" ]; return findItem (list152, part, controlParts (name)); }
        if (!std.string.icmp (name, "Header")) { const char [] [] list153 = [ "HP_HEADERITEM", "HP_HEADERITEMLEFT", "HP_HEADERITEMRIGHT", "HP_HEADERSORTARROW" ]; return findItem (list153, part, controlParts (name)); }
        if (!std.string.icmp (name, "ListView")) { const char [] [] list154 = [ "LVP_EMPTYTEXT", "LVP_LISTDETAIL", "LVP_LISTGROUP", "LVP_LISTITEM", "LVP_LISTSORTEDDETAIL" ]; return findItem (list154, part, controlParts (name)); }
        if (!std.string.icmp (name, "Menu")) { const char [] [] list155 = [ "MP_MENUBARDROPDOWN", "MP_MENUBARITEM", "MP_CHEVRON", "MP_MENUDROPDOWN", "MP_MENUITEM", "MP_SEPARATOR" ]; return findItem (list155, part, controlParts (name)); }
        if (!std.string.icmp (name, "MenuBand")) { const char [] [] list156 = [ "MDP_NEWAPPBUTTON", "MDP_SEPARATOR" ]; return findItem (list156, part, controlParts (name)); }
        if (!std.string.icmp (name, "Page")) { const char [] [] list157 = [ "PGRP_DOWN", "PGRP_DOWNHORZ", "PGRP_UP", "PGRP_UPHORZ" ]; return findItem (list157, part, controlParts (name)); }
        if (!std.string.icmp (name, "Progress")) { const char [] [] list158 = [ "PP_BAR", "PP_BARVERT", "PP_CHUNK", "PP_CHUNKVERT" ]; return findItem (list158, part, controlParts (name)); }
        if (!std.string.icmp (name, "Rebar")) { const char [] [] list159 = [ "RP_BAND", "RP_CHEVRON", "RP_CHEVRONVERT", "RP_GRIPPER", "RP_GRIPPERVERT" ]; return findItem (list159, part, controlParts (name)); }
        if (!std.string.icmp (name, "ScrollBar")) { const char [] [] list160 = [ "SBP_ARROWBTN", "SBP_GRIPPERHORZ", "SBP_GRIPPERVERT", "SBP_LOWERTRACKHORZ", "SBP_LOWERTRACKVERT", "SBP_THUMBBTNHORZ", "SBP_THUMBBTNVERT", "SBP_UPPERTRACKHORZ", "SBP_UPPERTRACKVERT", "SBP_SIZEBOX" ]; return findItem (list160, part, controlParts (name)); }
        if (!std.string.icmp (name, "Spin")) { const char [] [] list161 = [ "SPNP_DOWN", "SPNP_DOWNHORZ", "SPNP_UP", "SPNP_UPHORZ" ]; return findItem (list161, part, controlParts (name)); }
        if (!std.string.icmp (name, "StartPanel")) { const char [] [] list162 = [ "SPP_LOGOFF", "SPP_LOGOFFBUTTONS", "SPP_MOREPROGRAMS", "SPP_MOREPROGRAMSARROW", "SPP_PLACESLIST", "SPP_PLACESLISTSEPARATOR", "SPP_PREVIEW", "SPP_PROGLIST", "SPP_PROGLISTSEPARATOR", "SPP_USERPANE", "SPP_USERPICTURE" ]; return findItem (list162, part, controlParts (name)); }
        if (!std.string.icmp (name, "Status")) { const char [] [] list163 = [ "SP_GRIPPER", "SP_PANE", "SP_GRIPPERPANE" ]; return findItem (list163, part, controlParts (name)); }
        if (!std.string.icmp (name, "Tab")) { const char [] [] list164 = [ "TABP_BODY", "TABP_PANE", "TABP_TABITEM", "TABP_TABITEMBOTHEDGE", "TABP_TABITEMLEFTEDGE", "TABP_TABITEMRIGHTEDGE", "TABP_TOPTABITEM", "TABP_TOPTABITEMBOTHEDGE", "TABP_TOPTABITEMLEFTEDGE", "TABP_TOPTABITEMRIGHTEDGE" ]; return findItem (list164, part, controlParts (name)); }
        if (!std.string.icmp (name, "TaskBand")) { const char [] [] list165 = [ "TDP_GROUPCOUNT", "TDP_FLASHBUTTON", "TDP_FLASHBUTTONGROUPMENU" ]; return findItem (list165, part, controlParts (name)); }
        if (!std.string.icmp (name, "TaskBar")) { const char [] [] list166 = [ "TBP_BACKGROUNDBOTTOM", "TBP_BACKGROUNDLEFT", "TBP_BACKGROUNDRIGHT", "TBP_BACKGROUNDTOP", "TBP_SIZINGBARBOTTOM", "TBP_SIZINGBARLEFT", "TBP_SIZINGBARRIGHT", "TBP_SIZINGBARTOP" ]; return findItem (list166, part, controlParts (name)); }
        if (!std.string.icmp (name, "ToolBar")) { const char [] [] list167 = [ "TP_BUTTON", "TP_DROPDOWNBUTTON", "TP_SPLITBUTTON", "TP_SPLITBUTTONDROPDOWN", "TP_SEPARATOR", "TP_SEPARATORVERT" ]; return findItem (list167, part, controlParts (name)); }
        if (!std.string.icmp (name, "ToolTip")) { const char [] [] list168 = [ "TTP_BALLOON", "TTP_BALLOONTITLE", "TTP_CLOSE", "TTP_STANDARD", "TTP_STANDARDTITLE" ]; return findItem (list168, part, controlParts (name)); }
        if (!std.string.icmp (name, "TrackBar")) { const char [] [] list169 = [ "TKP_THUMB", "TKP_THUMBBOTTOM", "TKP_THUMBLEFT", "TKP_THUMBRIGHT", "TKP_THUMBTOP", "TKP_THUMBVERT", "TKP_TICS", "TKP_TICSVERT", "TKP_TRACK", "TKP_TRACKVERT" ]; return findItem (list169, part, controlParts (name)); }
        if (!std.string.icmp (name, "TrayNotify")) { const char [] [] list170 = [ "TNP_ANIMBACKGROUND", "TNP_BACKGROUND" ]; return findItem (list170, part, controlParts (name)); }
        if (!std.string.icmp (name, "TreeView")) { const char [] [] list171 = [ "TVP_BRANCH", "TVP_GLYPH", "TVP_TREEITEM" ]; return findItem (list171, part, controlParts (name)); }
        if (!std.string.icmp (name, "Window")) { const char [] [] list172 = [ "WP_CAPTION", "WP_CAPTIONSIZINGTEMPLATE", "WP_CLOSEBUTTON", 
            "WP_DIALOG", "WP_FRAMEBOTTOM", "WP_FRAMEBOTTOMSIZINGTEMPLATE", "WP_FRAMELEFT", 
            "WP_FRAMELEFTSIZINGTEMPLATE", "WP_FRAMERIGHT", "WP_FRAMERIGHTSIZINGTEMPLATE", "WP_HELPBUTTON", 
            "WP_HORZSCROLL", "WP_HORZTHUMB", "WP_MAXBUTTON", "WP_MAXCAPTION", "WP_MDICLOSEBUTTON", 
            "WP_MDIHELPBUTTON", "WP_MDIMINBUTTON", "WP_MDIRESTOREBUTTON", "WP_MDISYSBUTTON", "WP_MINBUTTON", 
            "WP_MINCAPTION", "WP_RESTOREBUTTON", "WP_SMALLCAPTION", "WP_SMALLCAPTIONSIZINGTEMPLATE", 
            "WP_SMALLCLOSEBUTTON", "WP_SMALLFRAMEBOTTOM", "WP_SMALLFRAMEBOTTOMSIZINGTEMPLATE", 
            "WP_SMALLFRAMELEFT", "WP_SMALLFRAMELEFTSIZINGTEMPLATE", "WP_SMALLFRAMERIGHT", 
            "WP_SMALLFRAMERIGHTSIZINGTEMPLATE", 
            "WP_SMALLMAXCAPTION", "WP_SMALLMINCAPTION", 
            "WP_SYSBUTTON", "WP_VERTSCROLL", "WP_VERTTHUMB" ]; return findItem (list172, part, controlParts (name)); }
        throw new Error ("controlPartName " ~ name);
    }

    char [] controlPartStateName (char [] name, int part, int state)
    {
        char [] [] names = controlPartStateNames (name, part);
        int [] values = controlPartStates (name, part);

        for (int c; ; c ++)
            if (values [c] == state)
                return names [c];
    }

    char [] [] controlPartStateNames (char [] name, int part)
    {
        switch (std.string.tolower (name))
        {
            case "button":
                if (part == BP_PUSHBUTTON) { const char [] [] list74 = [ "PBS_NORMAL", "PBS_HOT", "PBS_PRESSED", "PBS_DISABLED", "PBS_DEFAULTED" ]; return list74; }
                if (part == BP_RADIOBUTTON) { const char [] [] list75 = [ "RBS_UNCHECKEDNORMAL", "RBS_UNCHECKEDHOT", "RBS_UNCHECKEDPRESSED", "RBS_UNCHECKEDDISABLED", "RBS_CHECKEDNORMAL", "RBS_CHECKEDHOT", "RBS_CHECKEDPRESSED", "RBS_CHECKEDDISABLED" ]; return list75; }
                if (part == BP_CHECKBOX) { const char [] [] list76 = [ "CBS_UNCHECKEDNORMAL", "CBS_UNCHECKEDHOT", "CBS_UNCHECKEDPRESSED", "CBS_UNCHECKEDDISABLED", "CBS_CHECKEDNORMAL", "CBS_CHECKEDHOT", "CBS_CHECKEDPRESSED", "CBS_CHECKEDDISABLED", "CBS_MIXEDNORMAL", "CBS_MIXEDHOT", "CBS_MIXEDPRESSED", "CBS_MIXEDDISABLED" ]; return list76; }
                if (part == BP_GROUPBOX) { const char [] [] list77 = [ "GBS_NORMAL", "GBS_DISABLE" ]; return list77; }
                if (part == BP_USERBUTTON) return null;
                goto failed;

            case "clock":
                if (part == CLP_TIME) { const char [] [] list78 = [ "CLS_NORMAL" ]; return list78; }
                goto failed;

            case "combobox":
                if (part == CP_DROPDOWNBUTTON) { const char [] [] list79 = [ "CBXS_NORMAL", "CBXS_HOT", "CBXS_PRESSED", "CBXS_DISABLED" ]; return list79; }
                goto failed;

            case "edit":
                if (part == EP_EDITTEXT) { const char [] [] list80 = [ "ETS_NORMAL", "ETS_HOT", "ETS_SELECTED", "ETS_DISABLED", "ETS_FOCUSED", "ETS_READONLY", "ETS_ASSIST" ]; return list80; }
                if (part == EP_CARET) return null;
                goto failed;

            case "explorerbar":
                if (part == EBP_HEADERBACKGROUND) return null;
                if (part == EBP_HEADERCLOSE) { const char [] [] list81 = [ "EBHC_NORMAL", "EBHC_HOT", "EBHC_PRESSED" ]; return list81; }
                if (part == EBP_HEADERPIN) { const char [] [] list82 = [ "EBHP_NORMAL", "EBHP_HOT", "EBHP_PRESSED", "EBHP_SELECTEDNORMAL", "EBHP_SELECTEDHOT", "EBHP_SELECTEDPRESSED" ]; return list82; }
                if (part == EBP_IEBARMENU) { const char [] [] list83 = [ "EBM_NORMAL", "EBM_HOT", "EBM_PRESSED" ]; return list83; }
                if (part == EBP_NORMALGROUPBACKGROUND) return null;
                if (part == EBP_NORMALGROUPCOLLAPSE) { const char [] [] list84 = [ "EBNGC_NORMAL", "EBNGC_HOT", "EBNGC_PRESSED" ]; return list84; }
                if (part == EBP_NORMALGROUPEXPAND) { const char [] [] list85 = [ "EBNGE_NORMAL", "EBNGE_HOT", "EBNGE_PRESSED" ]; return list85; }
                if (part == EBP_NORMALGROUPHEAD) return null;
                if (part == EBP_SPECIALGROUPBACKGROUND) return null;
                if (part == EBP_SPECIALGROUPCOLLAPSE) { const char [] [] list86 = [ "EBSGC_NORMAL", "EBSGC_HOT", "EBSGC_PRESSED" ]; return list86; }
                if (part == EBP_SPECIALGROUPEXPAND) { const char [] [] list87 = [ "EBSGE_NORMAL", "EBSGE_HOT", "EBSGE_PRESSED" ]; return list87; }
                if (part == EBP_SPECIALGROUPHEAD) return null;
                goto failed;

            case "globals":
                if (part == GP_BORDER) return null;
                if (part == GP_LINEHORZ) return null;
                if (part == GP_LINEVERT) return null;
                goto failed;

            case "header":
                if (part == HP_HEADERITEM) { const char [] [] list88 = [ "HIS_NORMAL", "HIS_HOT", "HIS_PRESSED" ]; return list88; }
                if (part == HP_HEADERITEMLEFT) { const char [] [] list89 = [ "HILS_NORMAL", "HILS_HOT", "HILS_PRESSED" ]; return list89; }
                if (part == HP_HEADERITEMRIGHT) { const char [] [] list90 = [ "HIRS_NORMAL", "HIRS_HOT", "HIRS_PRESSED" ]; return list90; }
                if (part == HP_HEADERSORTARROW) { const char [] [] list91 = [ "HSAS_SORTEDUP", "HSAS_SORTEDDOWN" ]; return list91; }
                goto failed;

            case "listview":
                if (part == LVP_LISTITEM) { const char [] [] list92 = [ "LIS_NORMAL", "LIS_HOT", "LIS_SELECTED", "LIS_DISABLED", "LIS_SELECTEDNOTFOCUS" ]; return list92; }
                if (part == LVP_LISTGROUP) return null;
                if (part == LVP_LISTDETAIL) return null;
                if (part == LVP_LISTSORTEDDETAIL) return null;
                if (part == LVP_EMPTYTEXT) return null;
                goto failed;

            case "menu":
                if (part == MP_MENUITEM || part == MP_MENUDROPDOWN || part == MP_MENUBARITEM || part == MP_MENUBARDROPDOWN || part == MP_CHEVRON || part == MP_SEPARATOR) { const char [] [] list93 = [ "MS_NORMAL", "MS_SELECTED", "MS_DEMOTED" ]; return list93; }
                goto failed;

            case "menuband":
                if (part == MDP_NEWAPPBUTTON) { const char [] [] list94 = [ "MDS_NORMAL", "MDS_HOT", "MDS_PRESSED", "MDS_DISABLED", "MDS_CHECKED", "MDS_HOTCHECKED" ]; return list94; }
                if (part == MDP_SEPARATOR) return null;
                goto failed;

            case "page":
                if (part == PGRP_UP) { const char [] [] list95 = [ "UPS_NORMAL", "UPS_HOT", "UPS_PRESSED", "UPS_DISABLED" ]; return list95; }
                if (part == PGRP_DOWN) { const char [] [] list96 = [ "DNS_NORMAL", "DNS_HOT", "DNS_PRESSED", "DNS_DISABLED" ]; return list96; }
                if (part == PGRP_UPHORZ) { const char [] [] list97 = [ "UPHZS_NORMAL", "UPHZS_HOT", "UPHZS_PRESSED", "UPHZS_DISABLED" ]; return list97; }
                if (part == PGRP_DOWNHORZ) { const char [] [] list98 = [ "DNHZS_NORMAL", "DNHZS_HOT", "DNHZS_PRESSED", "DNHZS_DISABLED" ]; return list98; }
                goto failed;

            case "progress":
                if (part == PP_BAR) return null;
                if (part == PP_BARVERT) return null;
                if (part == PP_CHUNK) return null;
                if (part == PP_CHUNKVERT) return null;
                goto failed;

            case "rebar":
                if (part == RP_GRIPPER) return null;
                if (part == RP_GRIPPERVERT) return null;
                if (part == RP_BAND) return null;
                if (part == RP_CHEVRON) { const char [] [] list99 = [ "CHEVS_NORMAL", "CHEVS_HOT", "CHEVS_PRESSED" ]; return list99; }
                if (part == RP_CHEVRONVERT) return null;
                goto failed;

            case "scrollbar":
                if (part == SBP_ARROWBTN) { const char [] [] list100 = [ "ABS_UPNORMAL", "ABS_UPHOT", "ABS_UPPRESSED", "ABS_UPDISABLED", "ABS_DOWNNORMAL", "ABS_DOWNHOT", "ABS_DOWNPRESSED", "ABS_DOWNDISABLED", "ABS_LEFTNORMAL", "ABS_LEFTHOT", "ABS_LEFTPRESSED", "ABS_LEFTDISABLED", "ABS_RIGHTNORMAL", "ABS_RIGHTHOT", "ABS_RIGHTPRESSED", "ABS_RIGHTDISABLED" ]; return list100; }
                if (part == SBP_LOWERTRACKVERT || part == SBP_UPPERTRACKVERT || part == SBP_THUMBBTNHORZ || part == SBP_THUMBBTNVERT || part == SBP_LOWERTRACKHORZ || part == SBP_UPPERTRACKHORZ) { const char [] [] list101 = [ "SCRBS_NORMAL", "SCRBS_HOT", "SCRBS_PRESSED", "SCRBS_DISABLED" ]; return list101; }
                if (part == SBP_GRIPPERHORZ) return null;
                if (part == SBP_GRIPPERVERT) return null;
                if (part == SBP_SIZEBOX) { const char [] [] list102 = [ "SZB_RIGHTALIGN", "SZB_LEFTALIGN" ]; return list102; }
                goto failed;

            case "spin":
                if (part == SPNP_UP) { const char [] [] list103 = [ "UPS_NORMAL", "UPS_HOT", "UPS_PRESSED", "UPS_DISABLED" ]; return list103; }
                if (part == SPNP_DOWN) { const char [] [] list104 = [ "DNS_NORMAL", "DNS_HOT", "DNS_PRESSED", "DNS_DISABLED" ]; return list104; }
                if (part == SPNP_UPHORZ) { const char [] [] list105 = [ "UPHZS_NORMAL", "UPHZS_HOT", "UPHZS_PRESSED", "UPHZS_DISABLED" ]; return list105; }
                if (part == SPNP_DOWNHORZ) { const char [] [] list106 = [ "DNHZS_NORMAL", "DNHZS_HOT", "DNHZS_PRESSED", "DNHZS_DISABLED" ]; return list106; }
                goto failed;

            case "startpanel":
                if (part == SPP_USERPANE) return null;
                if (part == SPP_MOREPROGRAMS) return null;
                if (part == SPP_MOREPROGRAMSARROW) { const char [] [] list107 = [ "SPS_NORMAL", "SPS_HOT", "SPS_PRESSED" ]; return list107; }
                if (part == SPP_PROGLIST) return null;
                if (part == SPP_PROGLISTSEPARATOR) return null;
                if (part == SPP_PLACESLIST) return null;
                if (part == SPP_PLACESLISTSEPARATOR) return null;
                if (part == SPP_LOGOFF) return null;
                if (part == SPP_LOGOFFBUTTONS) { const char [] [] list108 = [ "SPLS_NORMAL", "SPLS_HOT", "SPLS_PRESSED" ]; return list108; }
                if (part == SPP_USERPICTURE ) return null;
                if (part == SPP_PREVIEW ) return null;
                goto failed;

            case "status":
                if (part == SP_PANE) return null;
                if (part == SP_GRIPPERPANE) return null;
                if (part == SP_GRIPPER) return null;
                goto failed;

            case "tab":
                if (part == TABP_TABITEM) { const char [] [] list109 = [ "TIS_NORMAL", "TIS_HOT", "TIS_SELECTED", "TIS_DISABLED", "TIS_FOCUSED" ]; return list109; }
                if (part == TABP_TABITEMLEFTEDGE) { const char [] [] list110 = [ "TILES_NORMAL", "TILES_HOT", "TILES_SELECTED", "TILES_DISABLED", "TILES_FOCUSED" ]; return list110; }
                if (part == TABP_TABITEMRIGHTEDGE) { const char [] [] list111 = [ "TIRES_NORMAL", "TIRES_HOT", "TIRES_SELECTED", "TIRES_DISABLED", "TIRES_FOCUSED" ]; return list111; }
                if (part == TABP_TABITEMBOTHEDGE) { const char [] [] list112 = [ "TIBES_NORMAL", "TIBES_HOT", "TIBES_SELECTED", "TIBES_DISABLED", "TIBES_FOCUSED" ]; return list112; }
                if (part == TABP_TOPTABITEM) { const char [] [] list113 = [ "TTIS_NORMAL", "TTIS_HOT", "TTIS_SELECTED", "TTIS_DISABLED", "TTIS_FOCUSED" ]; return list113; }
                if (part == TABP_TOPTABITEMLEFTEDGE) { const char [] [] list114 = [ "TTILES_NORMAL", "TTILES_HOT", "TTILES_SELECTED", "TTILES_DISABLED", "TTILES_FOCUSED" ]; return list114; }
                if (part == TABP_TOPTABITEMRIGHTEDGE) { const char [] [] list115 = [ "TTIRES_NORMAL", "TTIRES_HOT", "TTIRES_SELECTED", "TTIRES_DISABLED", "TTIRES_FOCUSED" ]; return list115; }
                if (part == TABP_TOPTABITEMBOTHEDGE) { const char [] [] list116 = [ "TTIBES_NORMAL", "TTIBES_HOT", "TTIBES_SELECTED", "TTIBES_DISABLED", "TTIBES_FOCUSED" ]; return list116; }
                if (part == TABP_PANE) return null;
                if (part == TABP_BODY ) return null;
                goto failed;

            case "taskband":
                if (part == TDP_GROUPCOUNT) return null;
                if (part == TDP_FLASHBUTTON) return null;
                if (part == TDP_FLASHBUTTONGROUPMENU) return null;
                goto failed;

            case "taskbar":
                if (part == TBP_BACKGROUNDBOTTOM) return null;
                if (part == TBP_BACKGROUNDRIGHT) return null;
                if (part == TBP_BACKGROUNDTOP) return null;
                if (part == TBP_BACKGROUNDLEFT) return null;
                if (part == TBP_SIZINGBARBOTTOM) return null;
                if (part == TBP_SIZINGBARRIGHT) return null;
                if (part == TBP_SIZINGBARTOP) return null;
                if (part == TBP_SIZINGBARLEFT) return null;
                goto failed;

            case "toolbar":
                if (part == TP_SEPARATORVERT || part == TP_SEPARATOR || part == TP_SPLITBUTTONDROPDOWN || part == TP_SPLITBUTTON || part == TP_DROPDOWNBUTTON || part == TP_BUTTON) { const char [] [] list117 = [ "TS_NORMAL", "TS_HOT", "TS_PRESSED", "TS_DISABLED", "TS_CHECKED", "TS_HOTCHECKED" ]; return list117; }
                goto failed;

            case "tooltip":
                if (part == TTP_STANDARDTITLE || part == TTP_STANDARD) { const char [] [] list118 = [ "TTSS_NORMAL", "TTSS_LINK" ]; return list118; }
                if (part == TTP_BALLOONTITLE || part == TTP_BALLOON) { const char [] [] list119 = [ "TTBS_NORMAL", "TTBS_LINK" ]; return list119; }
                if (part == TTP_CLOSE) { const char [] [] list120 = [ "TTCS_NORMAL", "TTCS_HOT", "TTCS_PRESSED" ]; return list120; }
                goto failed;

            case "trackbar":
                if (part == TKP_TRACK) { const char [] [] list121 = [ "TRS_NORMAL" ]; return list121; }
                if (part == TKP_TRACKVERT) { const char [] [] list122 = [ "TRVS_NORMAL" ]; return list122; }
                if (part == TKP_THUMB) { const char [] [] list123 = [ "TUS_NORMAL", "TUS_HOT", "TUS_PRESSED", "TUS_FOCUSED", "TUS_DISABLED" ]; return list123; }
                if (part == TKP_THUMBBOTTOM) { const char [] [] list124 = [ "TUBS_NORMAL", "TUBS_HOT", "TUBS_PRESSED", "TUBS_FOCUSED", "TUBS_DISABLED" ]; return list124; }
                if (part == TKP_THUMBTOP) { const char [] [] list125 = [ "TUTS_NORMAL", "TUTS_HOT", "TUTS_PRESSED", "TUTS_FOCUSED", "TUTS_DISABLED" ]; return list125; }
                if (part == TKP_THUMBVERT) { const char [] [] list126 = [ "TUVS_NORMAL", "TUVS_HOT", "TUVS_PRESSED", "TUVS_FOCUSED", "TUVS_DISABLED" ]; return list126; }
                if (part == TKP_THUMBLEFT) { const char [] [] list127 = [ "TUVLS_NORMAL", "TUVLS_HOT", "TUVLS_PRESSED", "TUVLS_FOCUSED", "TUVLS_DISABLED" ]; return list127; }
                if (part == TKP_THUMBRIGHT) { const char [] [] list128 = [ "TUVRS_NORMAL", "TUVRS_HOT", "TUVRS_PRESSED", "TUVRS_FOCUSED", "TUVRS_DISABLED" ]; return list128; }
                if (part == TKP_TICS) { const char [] [] list129 = [ "TSS_NORMAL" ]; return list129; }
                if (part == TKP_TICSVERT) { const char [] [] list130 = [ "TSVS_NORMAL" ]; return list130; }
                goto failed;

            case "traynotify":
                if (part == TNP_BACKGROUND) return null;
                if (part == TNP_ANIMBACKGROUND) return null;
                goto failed;

            case "treeview":
                if (part == TVP_TREEITEM) { const char [] [] list131 = [ "TREIS_NORMAL", "TREIS_HOT", "TREIS_SELECTED", "TREIS_DISABLED", "TREIS_SELECTEDNOTFOCUS" ]; return list131; }
                if (part == TVP_GLYPH) { const char [] [] list132 = [ "GLPS_CLOSED", "GLPS_OPENED" ]; return list132; }
                if (part == TVP_BRANCH) return null;
                goto failed;

            case "window":
                if (part == WP_CAPTION || part == WP_SMALLCAPTION) { const char [] [] list133 = [ "CS_ACTIVE", "CS_INACTIVE", "CS_DISABLED" ]; return list133; }
                if (part == WP_MINCAPTION || part == WP_SMALLMINCAPTION) { const char [] [] list134 = [ "MNCS_ACTIVE", "MNCS_INACTIVE", "MNCS_DISABLED" ]; return list134; }
                if (part == WP_MAXCAPTION || part == WP_SMALLMAXCAPTION) { const char [] [] list135 = [ "MXCS_ACTIVE", "MXCS_INACTIVE", "MXCS_DISABLED" ]; return list135; }
                if (part == WP_FRAMELEFT || part == WP_FRAMERIGHT || part == WP_FRAMEBOTTOM || part == WP_SMALLFRAMELEFT || part == WP_SMALLFRAMERIGHT || part == WP_SMALLFRAMEBOTTOM) { const char [] [] list136 = [ "FS_ACTIVE", "FS_INACTIVE" ]; return list136; }
                if (part == WP_SYSBUTTON || part == WP_MDISYSBUTTON) { const char [] [] list137 = [ "SBS_NORMAL", "SBS_HOT", "SBS_PUSHED", "SBS_DISABLED" ]; return list137; }
                if (part == WP_MINBUTTON || part == WP_MDIMINBUTTON) { const char [] [] list138 = [ "MINBS_NORMAL", "MINBS_HOT", "MINBS_PUSHED", "MINBS_DISABLED" ]; return list138; }
                if (part == WP_MAXBUTTON) { const char [] [] list139 = [ "MAXBS_NORMAL", "MAXBS_HOT", "MAXBS_PUSHED", "MAXBS_DISABLED" ]; return list139; }
                if (part == WP_CLOSEBUTTON || part == WP_SMALLCLOSEBUTTON || part == WP_MDICLOSEBUTTON) { const char [] [] list140 = [ "CBS_NORMAL", "CBS_HOT", "CBS_PUSHED", "CBS_DISABLED" ]; return list140; }
                if (part == WP_RESTOREBUTTON || part == WP_MDIRESTOREBUTTON) { const char [] [] list141 = [ "RBS_NORMAL", "RBS_HOT", "RBS_PUSHED", "RBS_DISABLED" ]; return list141; }
                if (part == WP_HELPBUTTON || part == WP_MDIHELPBUTTON) { const char [] [] list142 = [ "HBS_NORMAL", "HBS_HOT", "HBS_PUSHED", "HBS_DISABLED" ]; return list142; }
                if (part == WP_HORZSCROLL) { const char [] [] list143 = [ "HSS_NORMAL", "HSS_HOT", "HSS_PUSHED", "HSS_DISABLED" ]; return list143; }
                if (part == WP_HORZTHUMB) { const char [] [] list144 = [ "HTS_NORMAL", "HTS_HOT", "HTS_PUSHED", "HTS_DISABLED" ]; return list144; }
                if (part == WP_VERTSCROLL) { const char [] [] list145 = [ "VSS_NORMAL", "VSS_HOT", "VSS_PUSHED", "VSS_DISABLED" ]; return list145; }
                if (part == WP_VERTTHUMB) { const char [] [] list146 = [ "VTS_NORMAL", "VTS_HOT", "VTS_PUSHED", "VTS_DISABLED" ]; return list146; }
                if (part == WP_DIALOG ) return null;
                if (part == WP_CAPTIONSIZINGTEMPLATE ) return null;
                if (part == WP_SMALLCAPTIONSIZINGTEMPLATE ) return null;
                if (part == WP_FRAMELEFTSIZINGTEMPLATE ) return null;
                if (part == WP_SMALLFRAMELEFTSIZINGTEMPLATE ) return null;
                if (part == WP_FRAMERIGHTSIZINGTEMPLATE ) return null;
                if (part == WP_SMALLFRAMERIGHTSIZINGTEMPLATE ) return null;
                if (part == WP_FRAMEBOTTOMSIZINGTEMPLATE ) return null;
                if (part == WP_SMALLFRAMEBOTTOMSIZINGTEMPLATE ) return null;
                goto failed;

            default:
            failed:
                throw new Error (fmt ("controlPartStateNames %.*s %d", name, part));
        }
    }

    int [] controlPartStates (char [] name, int part)
    {
        switch (std.string.tolower (name))
        {
            case "button":
                if (part == BP_PUSHBUTTON) { const int [] list1 = [ PBS_NORMAL, PBS_HOT, PBS_PRESSED, PBS_DISABLED, PBS_DEFAULTED ]; return list1; }
                if (part == BP_RADIOBUTTON) { const int [] list2 = [ RBS_UNCHECKEDNORMAL, RBS_UNCHECKEDHOT, RBS_UNCHECKEDPRESSED, RBS_UNCHECKEDDISABLED, RBS_CHECKEDNORMAL, RBS_CHECKEDHOT, RBS_CHECKEDPRESSED, RBS_CHECKEDDISABLED ]; return list2; }
                if (part == BP_CHECKBOX) { const int [] list3 = [ CBS_UNCHECKEDNORMAL, CBS_UNCHECKEDHOT, CBS_UNCHECKEDPRESSED, CBS_UNCHECKEDDISABLED, CBS_CHECKEDNORMAL, CBS_CHECKEDHOT, CBS_CHECKEDPRESSED, CBS_CHECKEDDISABLED, CBS_MIXEDNORMAL, CBS_MIXEDHOT, CBS_MIXEDPRESSED, CBS_MIXEDDISABLED ]; return list3; }
                if (part == BP_GROUPBOX) { const int [] list4 = [ GBS_NORMAL, GBS_DISABLED ]; return list4; }
                if (part == BP_USERBUTTON) return null;
                goto failed;

            case "clock":
                if (part == CLP_TIME) { const int [] list5 = [ CLS_NORMAL ]; return list5; }
                goto failed;

            case "combobox":
                if (part == CP_DROPDOWNBUTTON) { const int [] list6 = [ CBXS_NORMAL, CBXS_HOT, CBXS_PRESSED, CBXS_DISABLED ]; return list6; }
                goto failed;

            case "edit":
                if (part == EP_EDITTEXT) { const int [] list7 = [ ETS_NORMAL, ETS_HOT, ETS_SELECTED, ETS_DISABLED, ETS_FOCUSED, ETS_READONLY, ETS_ASSIST ]; return list7; }
                if (part == EP_CARET) return null;
                goto failed;

            case "explorerbar":
                if (part == EBP_HEADERBACKGROUND) return null;
                if (part == EBP_HEADERCLOSE) { const int [] list8 = [ EBHC_NORMAL, EBHC_HOT, EBHC_PRESSED ]; return list8; }
                if (part == EBP_HEADERPIN) { const int [] list9 = [ EBHP_NORMAL, EBHP_HOT, EBHP_PRESSED, EBHP_SELECTEDNORMAL, EBHP_SELECTEDHOT, EBHP_SELECTEDPRESSED ]; return list9; }
                if (part == EBP_IEBARMENU) { const int [] list10 = [ EBM_NORMAL, EBM_HOT, EBM_PRESSED ]; return list10; }
                if (part == EBP_NORMALGROUPBACKGROUND) return null;
                if (part == EBP_NORMALGROUPCOLLAPSE) { const int [] list11 = [ EBNGC_NORMAL, EBNGC_HOT, EBNGC_PRESSED ]; return list11; }
                if (part == EBP_NORMALGROUPEXPAND) { const int [] list12 = [ EBNGE_NORMAL, EBNGE_HOT, EBNGE_PRESSED ]; return list12; }
                if (part == EBP_NORMALGROUPHEAD) return null;
                if (part == EBP_SPECIALGROUPBACKGROUND) return null;
                if (part == EBP_SPECIALGROUPCOLLAPSE) { const int [] list13 = [ EBSGC_NORMAL, EBSGC_HOT, EBSGC_PRESSED ]; return list13; }
                if (part == EBP_SPECIALGROUPEXPAND) { const int [] list14 = [ EBSGE_NORMAL, EBSGE_HOT, EBSGE_PRESSED ]; return list14; }
                if (part == EBP_SPECIALGROUPHEAD) return null;
                goto failed;

            case "globals":
                if (part == GP_BORDER) return null;
                if (part == GP_LINEHORZ) return null;
                if (part == GP_LINEVERT) return null;
                goto failed;

            case "header":
                if (part == HP_HEADERITEM) { const int [] list15 = [ HIS_NORMAL, HIS_HOT, HIS_PRESSED ]; return list15; }
                if (part == HP_HEADERITEMLEFT) { const int [] list16 = [ HILS_NORMAL, HILS_HOT, HILS_PRESSED ]; return list16; }
                if (part == HP_HEADERITEMRIGHT) { const int [] list17 = [ HIRS_NORMAL, HIRS_HOT, HIRS_PRESSED ]; return list17; }
                if (part == HP_HEADERSORTARROW) { const int [] list18 = [ HSAS_SORTEDUP, HSAS_SORTEDDOWN ]; return list18; }
                goto failed;

            case "listview":
                if (part == LVP_LISTITEM) { const int [] list19 = [ LIS_NORMAL, LIS_HOT, LIS_SELECTED, LIS_DISABLED, LIS_SELECTEDNOTFOCUS ]; return list19; }
                if (part == LVP_LISTGROUP) return null;
                if (part == LVP_LISTDETAIL) return null;
                if (part == LVP_LISTSORTEDDETAIL) return null;
                if (part == LVP_EMPTYTEXT) return null;
                goto failed;

            case "menu":
                if (part == MP_MENUITEM || part == MP_MENUDROPDOWN || part == MP_MENUBARITEM || part == MP_MENUBARDROPDOWN || part == MP_CHEVRON || part == MP_SEPARATOR) { const int [] list20 = [ MS_NORMAL, MS_SELECTED, MS_DEMOTED ]; return list20; }
                goto failed;

            case "menuband":
                if (part == MDP_NEWAPPBUTTON) { const int [] list21 = [ MDS_NORMAL, MDS_HOT, MDS_PRESSED, MDS_DISABLED, MDS_CHECKED, MDS_HOTCHECKED ]; return list21; }
                if (part == MDP_SEPARATOR) return null;
                goto failed;

            case "page":
                if (part == PGRP_UP) { const int [] list22 = [ UPS_NORMAL, UPS_HOT, UPS_PRESSED, UPS_DISABLED ]; return list22; }
                if (part == PGRP_DOWN) { const int [] list23 = [ DNS_NORMAL, DNS_HOT, DNS_PRESSED, DNS_DISABLED ]; return list23; }
                if (part == PGRP_UPHORZ) { const int [] list24 = [ UPHZS_NORMAL, UPHZS_HOT, UPHZS_PRESSED, UPHZS_DISABLED ]; return list24; }
                if (part == PGRP_DOWNHORZ) { const int [] list25 = [ DNHZS_NORMAL, DNHZS_HOT, DNHZS_PRESSED, DNHZS_DISABLED ]; return list25; }
                goto failed;

            case "progress":
                if (part == PP_BAR) return null;
                if (part == PP_BARVERT) return null;
                if (part == PP_CHUNK) return null;
                if (part == PP_CHUNKVERT) return null;
                goto failed;

            case "rebar":
                if (part == RP_GRIPPER) return null;
                if (part == RP_GRIPPERVERT) return null;
                if (part == RP_BAND) return null;
                if (part == RP_CHEVRON) { const int [] list26 = [ CHEVS_NORMAL, CHEVS_HOT, CHEVS_PRESSED ]; return list26; }
                if (part == RP_CHEVRONVERT) return null;
                goto failed;

            case "scrollbar":
                if (part == SBP_ARROWBTN) { const int [] list27 = [ ABS_UPNORMAL, ABS_UPHOT, ABS_UPPRESSED, ABS_UPDISABLED, ABS_DOWNNORMAL, ABS_DOWNHOT, ABS_DOWNPRESSED, ABS_DOWNDISABLED, ABS_LEFTNORMAL, ABS_LEFTHOT, ABS_LEFTPRESSED, ABS_LEFTDISABLED, ABS_RIGHTNORMAL, ABS_RIGHTHOT, ABS_RIGHTPRESSED, ABS_RIGHTDISABLED ]; return list27; }
                if (part == SBP_LOWERTRACKVERT || part == SBP_UPPERTRACKVERT || part == SBP_THUMBBTNHORZ || part == SBP_THUMBBTNVERT || part == SBP_LOWERTRACKHORZ || part == SBP_UPPERTRACKHORZ) { const int [] list28 = [ SCRBS_NORMAL, SCRBS_HOT, SCRBS_PRESSED, SCRBS_DISABLED ]; return list28; }
                if (part == SBP_GRIPPERHORZ) return null;
                if (part == SBP_GRIPPERVERT) return null;
                if (part == SBP_SIZEBOX) { const int [] list29 = [ SZB_RIGHTALIGN, SZB_LEFTALIGN ]; return list29; }
                goto failed;

            case "spin":
                if (part == SPNP_UP) { const int [] list30 = [ UPS_NORMAL, UPS_HOT, UPS_PRESSED, UPS_DISABLED ]; return list30; }
                if (part == SPNP_DOWN) { const int [] list31 = [ DNS_NORMAL, DNS_HOT, DNS_PRESSED, DNS_DISABLED ]; return list31; }
                if (part == SPNP_UPHORZ) { const int [] list32 = [ UPHZS_NORMAL, UPHZS_HOT, UPHZS_PRESSED, UPHZS_DISABLED ]; return list32; }
                if (part == SPNP_DOWNHORZ) { const int [] list33 = [ DNHZS_NORMAL, DNHZS_HOT, DNHZS_PRESSED, DNHZS_DISABLED ]; return list33; }
                goto failed;

            case "startpanel":
                if (part == SPP_USERPANE) return null;
                if (part == SPP_MOREPROGRAMS) return null;
                if (part == SPP_MOREPROGRAMSARROW) { const int [] list34 = [ SPS_NORMAL, SPS_HOT, SPS_PRESSED ]; return list34; }
                if (part == SPP_PROGLIST) return null;
                if (part == SPP_PROGLISTSEPARATOR) return null;
                if (part == SPP_PLACESLIST) return null;
                if (part == SPP_PLACESLISTSEPARATOR) return null;
                if (part == SPP_LOGOFF) return null;
                if (part == SPP_LOGOFFBUTTONS) { const int [] list35 = [ SPLS_NORMAL, SPLS_HOT, SPLS_PRESSED ]; return list35; }
                if (part == SPP_USERPICTURE ) return null;
                if (part == SPP_PREVIEW ) return null;
                goto failed;

            case "status":
                if (part == SP_PANE) return null;
                if (part == SP_GRIPPERPANE) return null;
                if (part == SP_GRIPPER) return null;
                goto failed;

            case "tab":
                if (part == TABP_TABITEM) { const int [] list36 = [ TIS_NORMAL, TIS_HOT, TIS_SELECTED, TIS_DISABLED, TIS_FOCUSED ]; return list36; }
                if (part == TABP_TABITEMLEFTEDGE) { const int [] list37 = [ TILES_NORMAL, TILES_HOT, TILES_SELECTED, TILES_DISABLED, TILES_FOCUSED ]; return list37; }
                if (part == TABP_TABITEMRIGHTEDGE) { const int [] list38 = [ TIRES_NORMAL, TIRES_HOT, TIRES_SELECTED, TIRES_DISABLED, TIRES_FOCUSED ]; return list38; }
                if (part == TABP_TABITEMBOTHEDGE) { const int [] list39 = [ TIBES_NORMAL, TIBES_HOT, TIBES_SELECTED, TIBES_DISABLED, TIBES_FOCUSED ]; return list39; }
                if (part == TABP_TOPTABITEM) { const int [] list40 = [ TTIS_NORMAL, TTIS_HOT, TTIS_SELECTED, TTIS_DISABLED, TTIS_FOCUSED ]; return list40; }
                if (part == TABP_TOPTABITEMLEFTEDGE) { const int [] list41 = [ TTILES_NORMAL, TTILES_HOT, TTILES_SELECTED, TTILES_DISABLED, TTILES_FOCUSED ]; return list41; }
                if (part == TABP_TOPTABITEMRIGHTEDGE) { const int [] list42 = [ TTIRES_NORMAL, TTIRES_HOT, TTIRES_SELECTED, TTIRES_DISABLED, TTIRES_FOCUSED ]; return list42; }
                if (part == TABP_TOPTABITEMBOTHEDGE) { const int [] list43 = [ TTIBES_NORMAL, TTIBES_HOT, TTIBES_SELECTED, TTIBES_DISABLED, TTIBES_FOCUSED ]; return list43; }
                if (part == TABP_PANE) return null;
                if (part == TABP_BODY ) return null;
                goto failed;

            case "taskband":
                if (part == TDP_GROUPCOUNT) return null;
                if (part == TDP_FLASHBUTTON) return null;
                if (part == TDP_FLASHBUTTONGROUPMENU) return null;
                goto failed;

            case "toolbar":
                if (part == TP_SEPARATORVERT || part == TP_SEPARATOR || part == TP_SPLITBUTTONDROPDOWN || part == TP_SPLITBUTTON || part == TP_DROPDOWNBUTTON || part == TP_BUTTON) { const int [] list44 = [ TS_NORMAL, TS_HOT, TS_PRESSED, TS_DISABLED, TS_CHECKED, TS_HOTCHECKED ]; return list44; }
                goto failed;

            case "tooltip":
                if (part == TTP_STANDARDTITLE || part == TTP_STANDARD) { const int [] list45 = [ TTSS_NORMAL, TTSS_LINK ]; return list45; }
                if (part == TTP_BALLOONTITLE || part == TTP_BALLOON) { const int [] list46 = [ TTBS_NORMAL, TTBS_LINK ]; return list46; }
                if (part == TTP_CLOSE) { const int [] list47 = [ TTCS_NORMAL, TTCS_HOT, TTCS_PRESSED ]; return list47; }
                goto failed;

            case "trackbar":
                if (part == TKP_TRACK) { const int [] list48 = [ TRS_NORMAL ]; return list48; }
                if (part == TKP_TRACKVERT) { const int [] list49 = [ TRVS_NORMAL ]; return list49; }
                if (part == TKP_THUMB) { const int [] list50 = [ TUS_NORMAL, TUS_HOT, TUS_PRESSED, TUS_FOCUSED, TUS_DISABLED ]; return list50; }
                if (part == TKP_THUMBBOTTOM) { const int [] list51 = [ TUBS_NORMAL, TUBS_HOT, TUBS_PRESSED, TUBS_FOCUSED, TUBS_DISABLED ]; return list51; }
                if (part == TKP_THUMBTOP) { const int [] list52 = [ TUTS_NORMAL, TUTS_HOT, TUTS_PRESSED, TUTS_FOCUSED, TUTS_DISABLED ]; return list52; }
                if (part == TKP_THUMBVERT) { const int [] list53 = [ TUVS_NORMAL, TUVS_HOT, TUVS_PRESSED, TUVS_FOCUSED, TUVS_DISABLED ]; return list53; }
                if (part == TKP_THUMBLEFT) { const int [] list54 = [ TUVLS_NORMAL, TUVLS_HOT, TUVLS_PRESSED, TUVLS_FOCUSED, TUVLS_DISABLED ]; return list54; }
                if (part == TKP_THUMBRIGHT) { const int [] list55 = [ TUVRS_NORMAL, TUVRS_HOT, TUVRS_PRESSED, TUVRS_FOCUSED, TUVRS_DISABLED ]; return list55; }
                if (part == TKP_TICS) { const int [] list56 = [ TSS_NORMAL ]; return list56; }
                if (part == TKP_TICSVERT) { const int [] list57 = [ TSVS_NORMAL ]; return list57; }
                goto failed;

            case "traynotify":
                if (part == TNP_BACKGROUND) return null;
                if (part == TNP_ANIMBACKGROUND) return null;
                goto failed;

            case "treeview":
                if (part == TVP_TREEITEM) { const int [] list58 = [ TREIS_NORMAL, TREIS_HOT, TREIS_SELECTED, TREIS_DISABLED, TREIS_SELECTEDNOTFOCUS ]; return list58; }
                if (part == TVP_GLYPH) { const int [] list59 = [ GLPS_CLOSED, GLPS_OPENED ]; return list59; }
                if (part == TVP_BRANCH) return null;
                goto failed;

            case "window":
                if (part == WP_CAPTION || part == WP_SMALLCAPTION) { const int [] list60 = [ CS_ACTIVE, CS_INACTIVE, CS_DISABLED ]; return list60; }
                if (part == WP_MINCAPTION || part == WP_SMALLMINCAPTION) { const int [] list61 = [ MNCS_ACTIVE, MNCS_INACTIVE, MNCS_DISABLED ]; return list61; }
                if (part == WP_MAXCAPTION || part == WP_SMALLMAXCAPTION) { const int [] list62 = [ MXCS_ACTIVE, MXCS_INACTIVE, MXCS_DISABLED ]; return list62; }
                if (part == WP_FRAMELEFT || part == WP_FRAMERIGHT || part == WP_FRAMEBOTTOM || part == WP_SMALLFRAMELEFT || part == WP_SMALLFRAMERIGHT || part == WP_SMALLFRAMEBOTTOM) { const int [] list63 = [ FS_ACTIVE, FS_INACTIVE ]; return list63; }
                if (part == WP_SYSBUTTON || part == WP_MDISYSBUTTON) { const int [] list64 = [ SBS_NORMAL, SBS_HOT, SBS_PUSHED, SBS_DISABLED ]; return list64; }
                if (part == WP_MINBUTTON || part == WP_MDIMINBUTTON) { const int [] list65 = [ MINBS_NORMAL, MINBS_HOT, MINBS_PUSHED, MINBS_DISABLED ]; return list65; }
                if (part == WP_MAXBUTTON) { const int [] list66 = [ MAXBS_NORMAL, MAXBS_HOT, MAXBS_PUSHED, MAXBS_DISABLED ]; return list66; }
                if (part == WP_CLOSEBUTTON || part == WP_SMALLCLOSEBUTTON || part == WP_MDICLOSEBUTTON) { const int [] list67 = [ CBS_NORMAL, CBS_HOT, CBS_PUSHED, CBS_DISABLED ]; return list67; }
                if (part == WP_RESTOREBUTTON || part == WP_MDIRESTOREBUTTON) { const int [] list68 = [ RBS_NORMAL, RBS_HOT, RBS_PUSHED, RBS_DISABLED ]; return list68; }
                if (part == WP_HELPBUTTON || part == WP_MDIHELPBUTTON) { const int [] list69 = [ HBS_NORMAL, HBS_HOT, HBS_PUSHED, HBS_DISABLED ]; return list69; }
                if (part == WP_HORZSCROLL) { const int [] list70 = [ HSS_NORMAL, HSS_HOT, HSS_PUSHED, HSS_DISABLED ]; return list70; }
                if (part == WP_HORZTHUMB) { const int [] list71 = [ HTS_NORMAL, HTS_HOT, HTS_PUSHED, HTS_DISABLED ]; return list71; }
                if (part == WP_VERTSCROLL) { const int [] list72 = [ VSS_NORMAL, VSS_HOT, VSS_PUSHED, VSS_DISABLED ]; return list72; }
                if (part == WP_VERTTHUMB) { const int [] list73 = [ VTS_NORMAL, VTS_HOT, VTS_PUSHED, VTS_DISABLED ]; return list73; }
                if (part == WP_DIALOG ) return null;
                if (part == WP_CAPTIONSIZINGTEMPLATE ) return null;
                if (part == WP_SMALLCAPTIONSIZINGTEMPLATE ) return null;
                if (part == WP_FRAMELEFTSIZINGTEMPLATE ) return null;
                if (part == WP_SMALLFRAMELEFTSIZINGTEMPLATE ) return null;
                if (part == WP_FRAMERIGHTSIZINGTEMPLATE ) return null;
                if (part == WP_SMALLFRAMERIGHTSIZINGTEMPLATE ) return null;
                if (part == WP_FRAMEBOTTOMSIZINGTEMPLATE ) return null;
                if (part == WP_SMALLFRAMEBOTTOMSIZINGTEMPLATE ) return null;
                goto failed;

            default:
            failed:
                throw new Error (fmt ("controlPartStates %.*s %d", name, part));
        }
    }

    char [] propertyEnumValueName (int index, int value)
    {
        if (index == TMT_BGTYPE)
        {
            if (value == 0) return "BT_IMAGEFILE";
            if (value == 1) return "BT_BORDERFILL";
            if (value == 2) return "BT_NONE";
        }

        if (index == TMT_IMAGELAYOUT)
        {
            if (value == 0) return "IL_VERTICAL";
            if (value == 1) return "IL_HORIZONTAL";
        }

        if (index == TMT_BORDERTYPE)
        {
            if (value == 0) return "BT_RECT";
            if (value == 1) return "BT_ROUNDRECT";
            if (value == 2) return "BT_ELLIPSE";
        }

        if (index == TMT_FILLTYPE)
        {
            if (value == 0) return "FT_SOLID";
            if (value == 1) return "FT_VERTGRADIENT";
            if (value == 2) return "FT_HORZGRADIENT";
            if (value == 3) return "FT_RADIALGRADIENT";
            if (value == 4) return "FT_TILEIMAGE";
        }

        if (index == TMT_SIZINGTYPE)
        {
            if (value == 0) return "ST_TRUESIZE";
            if (value == 1) return "ST_STRETCH";
            if (value == 2) return "ST_TILE";
        }

        if (index == TMT_HALIGN)
        {
            if (value == 0) return "HA_LEFT";
            if (value == 1) return "HA_CENTER";
            if (value == 2) return "HA_RIGHT";
        }

        if (index == TMT_CONTENTALIGNMENT)
        {
            if (value == 0) return "CA_LEFT";
            if (value == 1) return "CA_CENTER";
            if (value == 2) return "CA_RIGHT";
        }

        if (index == TMT_VALIGN)
        {
            if (value == 0) return "VA_TOP";
            if (value == 1) return "VA_CENTER";
            if (value == 2) return "VA_BOTTOM";
        }

        if (index == TMT_OFFSETTYPE)
        {
            if (value == 0) return "OT_TOPLEFT";
            if (value == 1) return "OT_TOPRIGHT";
            if (value == 2) return "OT_TOPMIDDLE";
            if (value == 3) return "OT_BOTTOMLEFT";
            if (value == 4) return "OT_BOTTOMRIGHT";
            if (value == 5) return "OT_BOTTOMMIDDLE";
            if (value == 6) return "OT_MIDDLELEFT";
            if (value == 7) return "OT_MIDDLERIGHT";
            if (value == 8) return "OT_LEFTOFCAPTION";
            if (value == 9) return "OT_RIGHTOFCAPTION";
            if (value == 10) return "OT_LEFTOFLASTBUTTON";
            if (value == 11) return "OT_RIGHTOFLASTBUTTON";
            if (value == 12) return "OT_ABOVELASTBUTTON";
            if (value == 13) return "OT_BELOWLASTBUTTON";
        }

        if (index == TMT_ICONEFFECT)
        {
            if (value == 0) return "ICE_NONE";
            if (value == 1) return "ICE_GLOW";
            if (value == 2) return "ICE_SHADOW";
            if (value == 3) return "ICE_PULSE";
            if (value == 4) return "ICE_ALPHA";
        }

        if (index == TMT_TEXTSHADOWTYPE)
        {
            if (value == 0) return "TST_NONE";
            if (value == 1) return "TST_SINGLE";
            if (value == 2) return "TST_CONTINUOUS";
        }

        if (index == TMT_GLYPHTYPE)
        {
            if (value == 0) return "GT_NONE";
            if (value == 1) return "GT_IMAGEGLYPH";
            if (value == 2) return "GT_FONTGLYPH";
        }

        if (index == TMT_IMAGESELECTTYPE)
        {
            if (value == 0) return "IST_NONE";
            if (value == 1) return "IST_SIZE";
            if (value == 2) return "IST_DPI";
        }

        if (index == TMT_TRUESIZESCALINGTYPE)
        {
            if (value == 0) return "TSST_NONE";
            if (value == 1) return "TSST_SIZE";
            if (value == 2) return "TSST_DPI";
        }

        if (index == TMT_GLYPHFONTSIZINGTYPE)
        {
            if (value == 0) return "GFST_NONE";
            if (value == 1) return "GFST_SIZE";
            if (value == 2) return "GFST_DPI";
        }
    }

    char [] propertyValue (int index, char [] id)
    {
        char [] type, name, desc;

        switch (index)
        {
            case TMT_CAPTIONFONT: type = "FONT"; name = "TMT_CAPTIONFONT"; break;
            case TMT_SMALLCAPTIONFONT: type = "FONT"; name = "TMT_SMALLCAPTIONFONT"; break;
            case TMT_MENUFONT: type = "FONT"; name = "TMT_MENUFONT"; break;
            case TMT_STATUSFONT: type = "FONT"; name = "TMT_STATUSFONT"; break;
            case TMT_MSGBOXFONT: type = "FONT"; name = "TMT_MSGBOXFONT"; break;
            case TMT_ICONTITLEFONT: type = "FONT"; name = "TMT_ICONTITLEFONT"; break;
            case TMT_SIZINGMARGINS: name = "TMT_SIZINGMARGINS"; type = "MARGINS"; desc = "margins used for 9-grid sizing"; break;
            case TMT_CONTENTMARGINS: name = "TMT_CONTENTMARGINS"; type = "MARGINS"; desc = "margins that define where content can be placed"; break;
            case TMT_CAPTIONMARGINS: name = "TMT_CAPTIONMARGINS"; type = "MARGINS"; desc = "margins that define where caption text can be placed"; break;
            case TMT_BORDERCOLOR: name = "TMT_BORDERCOLOR"; type = "COLOR"; desc = "color of borders for BorderFill "; break;
            case TMT_FILLCOLOR: name = "TMT_FILLCOLOR"; type = "COLOR"; desc = "color of bg fill "; break;
            case TMT_TEXTCOLOR: name = "TMT_TEXTCOLOR"; type = "COLOR"; desc = "color text is drawn in"; break;
            case TMT_EDGELIGHTCOLOR: name = "TMT_EDGELIGHTCOLOR"; type = "COLOR"; desc = "edge color"; break;
            case TMT_EDGEHIGHLIGHTCOLOR: name = "TMT_EDGEHIGHLIGHTCOLOR"; type = "COLOR"; desc = "edge color"; break;
            case TMT_EDGESHADOWCOLOR: name = "TMT_EDGESHADOWCOLOR"; type = "COLOR"; desc = "edge color"; break;
            case TMT_EDGEDKSHADOWCOLOR: name = "TMT_EDGEDKSHADOWCOLOR"; type = "COLOR"; desc = "edge color"; break;
            case TMT_EDGEFILLCOLOR: name = "TMT_EDGEFILLCOLOR"; type = "COLOR"; desc = "edge color"; break;
            case TMT_TRANSPARENTCOLOR: name = "TMT_TRANSPARENTCOLOR"; type = "COLOR"; desc = "color of pixels that are treated as transparent (not drawn)"; break;
            case TMT_GRADIENTCOLOR1: name = "TMT_GRADIENTCOLOR1"; type = "COLOR"; desc = "first color in gradient"; break;
            case TMT_GRADIENTCOLOR2: name = "TMT_GRADIENTCOLOR2"; type = "COLOR"; desc = "second color in gradient"; break;
            case TMT_GRADIENTCOLOR3: name = "TMT_GRADIENTCOLOR3"; type = "COLOR"; desc = "third color in gradient"; break;
            case TMT_GRADIENTCOLOR4: name = "TMT_GRADIENTCOLOR4"; type = "COLOR"; desc = "forth color in gradient"; break;
            case TMT_GRADIENTCOLOR5: name = "TMT_GRADIENTCOLOR5"; type = "COLOR"; desc = "fifth color in gradient"; break;
            case TMT_SHADOWCOLOR: name = "TMT_SHADOWCOLOR"; type = "COLOR"; desc = "color of text shadow"; break;
            case TMT_GLOWCOLOR: name = "TMT_GLOWCOLOR"; type = "COLOR"; desc = "color of glow produced by DrawThemeIcon"; break;
            case TMT_TEXTBORDERCOLOR: name = "TMT_TEXTBORDERCOLOR"; type = "COLOR"; desc = "color of text border"; break;
            case TMT_TEXTSHADOWCOLOR: name = "TMT_TEXTSHADOWCOLOR"; type = "COLOR"; desc = "color of text shadow"; break;
            case TMT_GLYPHTEXTCOLOR: name = "TMT_GLYPHTEXTCOLOR"; type = "COLOR"; desc = "color that font-based glyph is drawn with"; break;
            case TMT_GLYPHTRANSPARENTCOLOR: name = "TMT_GLYPHTRANSPARENTCOLOR"; type = "COLOR"; desc = "color of transparent pixels in GlyphImageFile"; break;
            case TMT_FILLCOLORHINT: name = "TMT_FILLCOLORHINT"; type = "COLOR"; desc = "hint about fill color used (for custom controls)"; break;
            case TMT_BORDERCOLORHINT: name = "TMT_BORDERCOLORHINT"; type = "COLOR"; desc = "hint about border color used (for custom controls)"; break;
            case TMT_ACCENTCOLORHINT: name = "TMT_ACCENTCOLORHINT"; type = "COLOR"; desc = "hint about accent color used (for custom controls)"; break;
            case TMT_BGTYPE: name = "TMT_BGTYPE"; type = "ENUM"; desc = "basic drawing type for each part"; break;
            case TMT_BORDERTYPE: name = "TMT_BORDERTYPE"; type = "ENUM"; desc = "type of border for BorderFill parts"; break;
            case TMT_FILLTYPE: name = "TMT_FILLTYPE"; type = "ENUM"; desc = "fill shape for BorderFill parts"; break;
            case TMT_SIZINGTYPE: name = "TMT_SIZINGTYPE"; type = "ENUM"; desc = "how to size ImageFile parts"; break;
            case TMT_HALIGN: name = "TMT_HALIGN"; type = "ENUM"; desc = "horizontal alignment for TRUESIZE parts & glyphs"; break;
            case TMT_CONTENTALIGNMENT: name = "TMT_CONTENTALIGNMENT"; type = "ENUM"; desc = "custom window prop: how text is aligned in caption"; break;
            case TMT_VALIGN: name = "TMT_VALIGN"; type = "ENUM"; desc = "horizontal alignment for TRUESIZE parts & glyphs"; break;
            case TMT_OFFSETTYPE: name = "TMT_OFFSETTYPE"; type = "ENUM"; desc = "how window part should be placed"; break;
            case TMT_ICONEFFECT: name = "TMT_ICONEFFECT"; type = "ENUM"; desc = "type of effect to use with DrawThemeIcon"; break;
            case TMT_TEXTSHADOWTYPE: name = "TMT_TEXTSHADOWTYPE"; type = "ENUM"; desc = "type of shadow to draw with text"; break;
            case TMT_IMAGELAYOUT: name = "TMT_IMAGELAYOUT"; type = "ENUM"; desc = "how multiple images are arranged (horz. or vert.)"; break;
            case TMT_GLYPHTYPE: name = "TMT_GLYPHTYPE"; type = "ENUM"; desc = "controls type of glyph in imagefile objects"; break;
            case TMT_IMAGESELECTTYPE: name = "TMT_IMAGESELECTTYPE"; type = "ENUM"; desc = "controls when to select from IMAGEFILE1...IMAGEFILE5"; break;
            case TMT_GLYPHFONTSIZINGTYPE: name = "TMT_GLYPHFONTSIZINGTYPE"; type = "ENUM"; desc = "controls when to select a bigger/small glyph font size"; break;
            case TMT_TRUESIZESCALINGTYPE: name = "TMT_TRUESIZESCALINGTYPE"; type = "ENUM"; desc = "controls how TrueSize image is scaled"; break;
            case TMT_TRANSPARENT: name = "TMT_TRANSPARENT"; type = "BOOL"; desc = "image has transparent areas (see TransparentColor)"; break;
            case TMT_AUTOSIZE: name = "TMT_AUTOSIZE"; type = "BOOL"; desc = "if TRUE, nonclient caption width varies with text extent"; break;
            case TMT_BORDERONLY: name = "TMT_BORDERONLY"; type = "BOOL"; desc = "only draw the border area of the image"; break;
            case TMT_COMPOSITED: name = "TMT_COMPOSITED"; type = "BOOL"; desc = "control will handle the composite drawing"; break;
            case TMT_BGFILL: name = "TMT_BGFILL"; type = "BOOL"; desc = "if TRUE, TRUESIZE images should be drawn on bg fill"; break;
            case TMT_GLYPHTRANSPARENT: name = "TMT_GLYPHTRANSPARENT"; type = "BOOL"; desc = "glyph has transparent areas (see GlyphTransparentColor)"; break;
            case TMT_GLYPHONLY: name = "TMT_GLYPHONLY"; type = "BOOL"; desc = "only draw glyph (not background)"; break;
            case TMT_ALWAYSSHOWSIZINGBAR: name = "TMT_ALWAYSSHOWSIZINGBAR"; type = "BOOL"; break;
            case TMT_MIRRORIMAGE: name = "TMT_MIRRORIMAGE"; type = "BOOL"; desc = "default=TRUE means image gets mirrored in RTL (Mirror) windows"; break;
            case TMT_UNIFORMSIZING: name = "TMT_UNIFORMSIZING"; type = "BOOL"; desc = "if TRUE, height & width must be uniformly sized "; break;
            case TMT_INTEGRALSIZING: name = "TMT_INTEGRALSIZING"; type = "BOOL"; desc = "for TRUESIZE and Border sizing; if TRUE, factor must be integer"; break;
            case TMT_SOURCEGROW: name = "TMT_SOURCEGROW"; type = "BOOL"; desc = "if TRUE, will scale up src image when needed"; break;
            case TMT_SOURCESHRINK: name = "TMT_SOURCESHRINK"; type = "BOOL"; desc = "if TRUE, will scale down src image when needed"; break;
            case TMT_IMAGECOUNT: name = "TMT_IMAGECOUNT"; type = "INT"; desc = "the number of state images in an imagefile"; break;
            case TMT_ALPHALEVEL: name = "TMT_ALPHALEVEL"; type = "INT"; desc = "(0-255) alpha value for an icon (DrawThemeIcon part)"; break;
            case TMT_BORDERSIZE: name = "TMT_BORDERSIZE"; type = "INT"; desc = "the size of the border line for bgtype=BorderFill"; break;
            case TMT_ROUNDCORNERWIDTH: name = "TMT_ROUNDCORNERWIDTH"; type = "INT"; desc = "(0-100) % of roundness for rounded rects"; break;
            case TMT_ROUNDCORNERHEIGHT: name = "TMT_ROUNDCORNERHEIGHT"; type = "INT"; desc = "(0-100) % of roundness for rounded rects"; break;
            case TMT_GRADIENTRATIO1: name = "TMT_GRADIENTRATIO1"; type = "INT"; desc = "(0-255) - amt of gradient color 1 to use (all must total=255)"; break;
            case TMT_GRADIENTRATIO2: name = "TMT_GRADIENTRATIO2"; type = "INT"; desc = "(0-255) - amt of gradient color 2 to use (all must total=255)"; break;
            case TMT_GRADIENTRATIO3: name = "TMT_GRADIENTRATIO3"; type = "INT"; desc = "(0-255) - amt of gradient color 3 to use (all must total=255)"; break;
            case TMT_GRADIENTRATIO4: name = "TMT_GRADIENTRATIO4"; type = "INT"; desc = "(0-255) - amt of gradient color 4 to use (all must total=255)"; break;
            case TMT_GRADIENTRATIO5: name = "TMT_GRADIENTRATIO5"; type = "INT"; desc = "(0-255) - amt of gradient color 5 to use (all must total=255)"; break;
            case TMT_PROGRESSCHUNKSIZE: name = "TMT_PROGRESSCHUNKSIZE"; type = "INT"; desc = "size of progress control chunks"; break;
            case TMT_PROGRESSSPACESIZE: name = "TMT_PROGRESSSPACESIZE"; type = "INT"; desc = "size of progress control spaces"; break;
            case TMT_SATURATION: name = "TMT_SATURATION"; type = "INT"; desc = "(0-255) amt of saturation for DrawThemeIcon() part"; break;
            case TMT_TEXTBORDERSIZE: name = "TMT_TEXTBORDERSIZE"; type = "INT"; desc = "size of border around text chars"; break;
            case TMT_ALPHATHRESHOLD: name = "TMT_ALPHATHRESHOLD"; type = "INT"; desc = "(0-255) the min. alpha value of a pixel that is solid"; break;
            case TMT_WIDTH: name = "TMT_WIDTH"; type = "SIZE"; desc = "custom window prop: size of part (min. window)"; break;
            case TMT_HEIGHT: name = "TMT_HEIGHT"; type = "SIZE"; desc = "custom window prop: size of part (min. window)"; break;
            case TMT_GLYPHINDEX: name = "TMT_GLYPHINDEX"; type = "INT"; desc = "for font-based glyphs, the char index into the font"; break;
            case TMT_TRUESIZESTRETCHMARK: name = "TMT_TRUESIZESTRETCHMARK"; type = "INT"; desc = "stretch TrueSize image when target exceeds source by this percent"; break;
            case TMT_MINDPI1: name = "TMT_MINDPI1"; type = "INT"; desc = "min DPI ImageFile1 was designed for"; break;
            case TMT_MINDPI2: name = "TMT_MINDPI2"; type = "INT"; desc = "min DPI ImageFile1 was designed for"; break;
            case TMT_MINDPI3: name = "TMT_MINDPI3"; type = "INT"; desc = "min DPI ImageFile1 was designed for"; break;
            case TMT_MINDPI4: name = "TMT_MINDPI4"; type = "INT"; desc = "min DPI ImageFile1 was designed for"; break;
            case TMT_MINDPI5: name = "TMT_MINDPI5"; type = "INT"; desc = "min DPI ImageFile1 was designed for"; break;
            case TMT_IMAGEFILE: name = "TMT_IMAGEFILE"; type = "FILENAME"; desc = "the filename of the image (or basename, for mult. images)"; break;
            case TMT_IMAGEFILE1: name = "TMT_IMAGEFILE1"; type = "FILENAME"; desc = "multiresolution image file"; break;
            case TMT_IMAGEFILE2: name = "TMT_IMAGEFILE2"; type = "FILENAME"; desc = "multiresolution image file"; break;
            case TMT_IMAGEFILE3: name = "TMT_IMAGEFILE3"; type = "FILENAME"; desc = "multiresolution image file"; break;
            case TMT_IMAGEFILE4: name = "TMT_IMAGEFILE4"; type = "FILENAME"; desc = "multiresolution image file"; break;
            case TMT_IMAGEFILE5: name = "TMT_IMAGEFILE5"; type = "FILENAME"; desc = "multiresolution image file"; break;
            case TMT_STOCKIMAGEFILE: name = "TMT_STOCKIMAGEFILE"; type = "FILENAME"; desc = "These are the only images that you can call GetThemeBitmap on"; break;
            case TMT_GLYPHIMAGEFILE: name = "TMT_GLYPHIMAGEFILE"; type = "FILENAME"; desc = "the filename for the glyph image"; break;
            default: name = fmt ("%d", index);
        }

        if (id == "type")
            return type;
        if (id == "name")
            return name;
        if (id == "desc")
            return desc;
    }

    void rect_set(inout _RECT rect, int left, int top, int right, int bottom)
    {
        rect.left = left;
        rect.top = top;
        rect.right = right;
        rect.bottom = bottom;
    }

    int [] themeAvailableProperties (HTHEME theme, _HDC hdc, int part, int state)
    {
        int [] list;
        _RECT rect;
        MARGINS margins;

        rect_set (rect, 0, 0, 100, 100);
        for (int prop; prop < 10000; prop ++)
            if (GetThemeMargins (theme, hdc, part, state, prop, &rect, &margins) == 0)
                list ~= prop;

        return list;
    }

    void themePrintAvailableProperties (HTHEME theme, _HDC hdc, int part, int state)
    {
        _RECT rect;
        MARGINS margins;

        rect_set (rect, 0, 0, 100, 100);

        for (int prop; prop < 10000; prop ++)
            if (GetThemeMargins (theme, hdc, part, state, prop, &rect, &margins) == 0)
            {
                char [] type = propertyValue (prop, "type");
                char [] name = propertyValue (prop, "name");
                char [] desc = propertyValue (prop, "desc");

                if (type == null)
                {
                    printf ("%.*s\n", name);
                    continue;
                }

                printf ("%.*s %.*s", type, name);

                if (type == "COLOR")
                {
                    _COLORREF ref;
                    Color color;

                    GetThemeColor (theme, part, state, prop, &ref);
                    color = AColor (ref & 0xFF, (ref >> 8) & 0xFF, (ref >> 16) & 0xFF);
                    printf (" = [%d %d %d]", color.r, color.g, color.b);
                }
                else if (type == "MARGINS")
                {
                    GetThemeMargins (theme, hdc, part, state, prop, &rect, &margins);
                    printf (" = %.*s", margins.toString ());
                }
                else if (type == "BOOL")
                {
                    _BOOL value;

                    GetThemeBool (theme, part, state, prop, &value);
                    printf (" = %.*s", value ? (char []) "TRUE" : (char []) "FALSE");
                }
                else if (type == "INT")
                {
                    int value;

                    GetThemeInt (theme, part, state, prop, &value);
                    printf (" = %d", value);
                }
                else if (type == "FILENAME")
                {
                    wchar [1024] value;

                    GetThemeFilename (theme, part, state, prop, value, value.length);
                    printf (" = \"%S\"", (wchar *) value);
                }
                else if (type == "ENUM")
                {
                    int value;

                    GetThemeEnumValue (theme, part, state, prop, &value);
                    printf (" = %.*s", propertyEnumValueName (prop, value));
                }

                desc = null;
                if (desc)
                    printf (" // %.*s\n", desc);
                else
                    printf ("\n");
            }
    }
}

/+
#endif
+/
